%------------------------------------------------------------------------------
% File     : COM199^1 : TPTP v9.2.0. Released v7.0.0.
% Domain   : Computing Theory
% Problem  : Koenig's lemma (about infinite trees) 84
% Version  : [Bla16] axioms : Especial.
% English  :

% Refs     : [BH+14] Blanchette et al. (2014), Truly Modular (Co)datatypes
%          : [RB15]  Reynolds & Blanchette (2015), A Decision Procedure for
%          : [Bla16] Blanchette (2016), Email to Geoff Sutcliffe
% Source   : [Bla16]
% Names    : koenig__84.p [Bla16]

% Status   : Theorem
% Rating   : 1.00 v7.5.0, 0.33 v7.2.0, 0.50 v7.1.0
% Syntax   : Number of formulae    :  333 ( 124 unt;  73 typ;   0 def)
%            Number of atoms       :  778 ( 316 equ;   4 cnn)
%            Maximal formula atoms :   11 (   2 avg)
%            Number of connectives : 5070 (  42   ~;  10   |;  67   &;4675   @)
%                                         (   0 <=>; 276  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   22 (   9 avg)
%            Number of types       :    2 (   1 usr)
%            Number of type conns  :  732 ( 732   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   76 (  72 usr;   7 con; 0-8 aty)
%            Number of variables   : 1404 ( 176   ^;1091   !;  33   ?;1404   :)
%                                         (  85  !>;   0  ?*;   0  @-;  19  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2016-07-13 14:38:47.968
%------------------------------------------------------------------------------
%----Could-be-implicit typings (6)
thf(ty_t_TreeFI_OtreeFI,type,
    treeFI: $tType > $tType ).

thf(ty_t_Stream_Ostream,type,
    stream: $tType > $tType ).

thf(ty_t_List_Olist,type,
    list: $tType > $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_itself,type,
    itself: $tType > $tType ).

thf(ty_tf_a,type,
    a: $tType ).

%----Explicit typings (67)
thf(sy_c_BNF__Def_Orel__fun,type,
    bNF_rel_fun: 
      !>[A: $tType,C: $tType,B: $tType,D: $tType] : ( ( A > C > $o ) > ( B > D > $o ) > ( A > B ) > ( C > D ) > $o ) ).

thf(sy_c_BNF__Greatest__Fixpoint_Ouniv,type,
    bNF_Greatest_univ: 
      !>[B: $tType,A: $tType] : ( ( B > A ) > ( set @ B ) > A ) ).

thf(sy_c_Basic__BNFs_Opred__fun,type,
    basic_pred_fun: 
      !>[A: $tType,B: $tType] : ( ( A > $o ) > ( B > $o ) > ( A > B ) > $o ) ).

thf(sy_c_Fun_Ocomp,type,
    comp: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( B > C ) > ( A > B ) > A > C ) ).

thf(sy_c_If,type,
    if: 
      !>[A: $tType] : ( $o > A > A > A ) ).

thf(sy_c_Koenig__Mirabelle__gyfieiccqy_OinfiniteTr,type,
    koenig488553731niteTr: 
      !>[A: $tType] : ( ( treeFI @ A ) > $o ) ).

thf(sy_c_Koenig__Mirabelle__gyfieiccqy_OkonigPath,type,
    koenig1103336060igPath: 
      !>[A: $tType] : ( ( treeFI @ A ) > ( stream @ A ) ) ).

thf(sy_c_Koenig__Mirabelle__gyfieiccqy_OproperPath,type,
    koenig1755522246erPath: 
      !>[A: $tType] : ( ( stream @ A ) > ( treeFI @ A ) > $o ) ).

thf(sy_c_List_Oappend,type,
    append: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Oconcat,type,
    concat: 
      !>[A: $tType] : ( ( list @ ( list @ A ) ) > ( list @ A ) ) ).

thf(sy_c_List_OdropWhile,type,
    dropWhile: 
      !>[A: $tType] : ( ( A > $o ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Ofilter,type,
    filter: 
      !>[A: $tType] : ( ( A > $o ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Ofold,type,
    fold: 
      !>[A: $tType,B: $tType] : ( ( A > B > B ) > ( list @ A ) > B > B ) ).

thf(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( B > A > B ) > B > ( list @ A ) > B ) ).

thf(sy_c_List_Ofoldr,type,
    foldr: 
      !>[A: $tType,B: $tType] : ( ( A > B > B ) > ( list @ A ) > B > B ) ).

thf(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( A > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olist_Ocase__list,type,
    case_list: 
      !>[B: $tType,A: $tType] : ( B > ( A > ( list @ A ) > B ) > ( list @ A ) > B ) ).

thf(sy_c_List_Olist_Olist__all,type,
    list_all: 
      !>[A: $tType] : ( ( A > $o ) > ( list @ A ) > $o ) ).

thf(sy_c_List_Olist_Olist__all2,type,
    list_all2: 
      !>[A: $tType,B: $tType] : ( ( A > B > $o ) > ( list @ A ) > ( list @ B ) > $o ) ).

thf(sy_c_List_Olist_Omap,type,
    map: 
      !>[A: $tType,Aa: $tType] : ( ( A > Aa ) > ( list @ A ) > ( list @ Aa ) ) ).

thf(sy_c_List_Olist_Orec__list,type,
    rec_list: 
      !>[C: $tType,A: $tType] : ( C > ( A > ( list @ A ) > C > C ) > ( list @ A ) > C ) ).

thf(sy_c_List_Olist_Oset,type,
    set2: 
      !>[A: $tType] : ( ( list @ A ) > ( set @ A ) ) ).

thf(sy_c_List_Olist__ex,type,
    list_ex: 
      !>[A: $tType] : ( ( A > $o ) > ( list @ A ) > $o ) ).

thf(sy_c_List_Omember,type,
    member: 
      !>[A: $tType] : ( ( list @ A ) > A > $o ) ).

thf(sy_c_List_Onull,type,
    null: 
      !>[A: $tType] : ( ( list @ A ) > $o ) ).

thf(sy_c_List_Oproduct__lists,type,
    product_lists: 
      !>[A: $tType] : ( ( list @ ( list @ A ) ) > ( list @ ( list @ A ) ) ) ).

thf(sy_c_List_Oremdups,type,
    remdups: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Oremdups__adj,type,
    remdups_adj: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Oremove1,type,
    remove1: 
      !>[A: $tType] : ( A > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_OremoveAll,type,
    removeAll: 
      !>[A: $tType] : ( A > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Orotate1,type,
    rotate1: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_OtakeWhile,type,
    takeWhile: 
      !>[A: $tType] : ( ( A > $o ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_Pure_Otype,type,
    type: 
      !>[A: $tType] : ( itself @ A ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Set_Ofilter,type,
    filter2: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) > ( set @ A ) ) ).

thf(sy_c_Set_Ois__empty,type,
    is_empty: 
      !>[A: $tType] : ( ( set @ A ) > $o ) ).

thf(sy_c_Set_Oremove,type,
    remove: 
      !>[A: $tType] : ( A > ( set @ A ) > ( set @ A ) ) ).

thf(sy_c_Stream_Osdrop__while,type,
    sdrop_while: 
      !>[A: $tType] : ( ( A > $o ) > ( stream @ A ) > ( stream @ A ) ) ).

thf(sy_c_Stream_Osfilter,type,
    sfilter: 
      !>[A: $tType] : ( ( A > $o ) > ( stream @ A ) > ( stream @ A ) ) ).

thf(sy_c_Stream_Oshift,type,
    shift: 
      !>[A: $tType] : ( ( list @ A ) > ( stream @ A ) > ( stream @ A ) ) ).

thf(sy_c_Stream_Osinterleave,type,
    sinterleave: 
      !>[A: $tType] : ( ( stream @ A ) > ( stream @ A ) > ( stream @ A ) ) ).

thf(sy_c_Stream_Osmap2,type,
    smap2: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( A > B > C ) > ( stream @ A ) > ( stream @ B ) > ( stream @ C ) ) ).

thf(sy_c_Stream_Osmember,type,
    smember: 
      !>[A: $tType] : ( A > ( stream @ A ) > $o ) ).

thf(sy_c_Stream_Ostream_OSCons,type,
    sCons: 
      !>[A: $tType] : ( A > ( stream @ A ) > ( stream @ A ) ) ).

thf(sy_c_Stream_Ostream_Ocase__stream,type,
    case_stream: 
      !>[A: $tType,B: $tType] : ( ( A > ( stream @ A ) > B ) > ( stream @ A ) > B ) ).

thf(sy_c_Stream_Ostream_Ocorec__stream,type,
    corec_stream: 
      !>[C: $tType,A: $tType] : ( ( C > A ) > ( C > $o ) > ( C > ( stream @ A ) ) > ( C > C ) > C > ( stream @ A ) ) ).

thf(sy_c_Stream_Ostream_Oshd,type,
    shd: 
      !>[A: $tType] : ( ( stream @ A ) > A ) ).

thf(sy_c_Stream_Ostream_Osmap,type,
    smap: 
      !>[A: $tType,Aa: $tType] : ( ( A > Aa ) > ( stream @ A ) > ( stream @ Aa ) ) ).

thf(sy_c_Stream_Ostream_Ostl,type,
    stl: 
      !>[A: $tType] : ( ( stream @ A ) > ( stream @ A ) ) ).

thf(sy_c_Stream_Ostream__all,type,
    stream_all: 
      !>[A: $tType] : ( ( A > $o ) > ( stream @ A ) > $o ) ).

thf(sy_c_Stream_Ostreams,type,
    streams: 
      !>[A: $tType] : ( ( set @ A ) > ( set @ ( stream @ A ) ) ) ).

thf(sy_c_Stream_Ostreamsp,type,
    streamsp: 
      !>[A: $tType] : ( ( A > $o ) > ( stream @ A ) > $o ) ).

thf(sy_c_Transfer_Obi__unique,type,
    bi_unique: 
      !>[A: $tType,B: $tType] : ( ( A > B > $o ) > $o ) ).

thf(sy_c_TreeFI_OtreeFI_OTree,type,
    tree: 
      !>[A: $tType] : ( A > ( list @ ( treeFI @ A ) ) > ( treeFI @ A ) ) ).

thf(sy_c_TreeFI_OtreeFI_Ocase__treeFI,type,
    case_treeFI: 
      !>[A: $tType,B: $tType] : ( ( A > ( list @ ( treeFI @ A ) ) > B ) > ( treeFI @ A ) > B ) ).

thf(sy_c_TreeFI_OtreeFI_Olab,type,
    lab: 
      !>[A: $tType] : ( ( treeFI @ A ) > A ) ).

thf(sy_c_TreeFI_OtreeFI_Opred__treeFI,type,
    pred_treeFI: 
      !>[A: $tType] : ( ( A > $o ) > ( treeFI @ A ) > $o ) ).

thf(sy_c_TreeFI_OtreeFI_Orel__treeFI,type,
    rel_treeFI: 
      !>[A: $tType,B: $tType] : ( ( A > B > $o ) > ( treeFI @ A ) > ( treeFI @ B ) > $o ) ).

thf(sy_c_TreeFI_OtreeFI_Oset__treeFI,type,
    set_treeFI: 
      !>[A: $tType] : ( ( treeFI @ A ) > ( set @ A ) ) ).

thf(sy_c_TreeFI_OtreeFI_Osub,type,
    sub: 
      !>[A: $tType] : ( ( treeFI @ A ) > ( list @ ( treeFI @ A ) ) ) ).

thf(sy_c_TreeFI_Otrev,type,
    trev: 
      !>[A: $tType] : ( ( treeFI @ A ) > ( treeFI @ A ) ) ).

thf(sy_c_member,type,
    member2: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_as____,type,
    as: stream @ a ).

thf(sy_v_asa____,type,
    asa: stream @ a ).

thf(sy_v_tr,type,
    tr: treeFI @ a ).

thf(sy_v_tra____,type,
    tra: treeFI @ a ).

%----Relevant facts (256)
thf(fact_0_assms,axiom,
    koenig488553731niteTr @ a @ tr ).

% assms
thf(fact_1_sub,axiom,
    ( ( koenig488553731niteTr @ a @ tra )
    & ( asa
      = ( koenig1103336060igPath @ a @ tra ) ) ) ).

% sub
thf(fact_2__092_060open_062infiniteTr_Atr_A_092_060and_062_Aas_____A_061_AkonigPath_Atr_092_060close_062,axiom,
    ( ( koenig488553731niteTr @ a @ tr )
    & ( as
      = ( koenig1103336060igPath @ a @ tr ) ) ) ).

% \<open>infiniteTr tr \<and> as__ = konigPath tr\<close>
thf(fact_3__092_060open_062_092_060exists_062t_H_092_060in_062set_A_Isub_Atr_J_O_AinfiniteTr_At_H_092_060close_062,axiom,
    ? [X: treeFI @ a] :
      ( ( member2 @ ( treeFI @ a ) @ X @ ( set2 @ ( treeFI @ a ) @ ( sub @ a @ tra ) ) )
      & ( koenig488553731niteTr @ a @ X ) ) ).

% \<open>\<exists>t'\<in>set (sub tr). infiniteTr t'\<close>
thf(fact_4__092_060open_062_092_060exists_062t_H_O_At_H_A_092_060in_062_Aset_A_Isub_Atr_J_A_092_060and_062_AinfiniteTr_At_H_092_060close_062,axiom,
    ? [T: treeFI @ a] :
      ( ( member2 @ ( treeFI @ a ) @ T @ ( set2 @ ( treeFI @ a ) @ ( sub @ a @ tra ) ) )
      & ( koenig488553731niteTr @ a @ T ) ) ).

% \<open>\<exists>t'. t' \<in> set (sub tr) \<and> infiniteTr t'\<close>
thf(fact_5_calculation,axiom,
    ( ( member2 @ ( treeFI @ a )
      @ @+[T2: treeFI @ a] :
          ( ( member2 @ ( treeFI @ a ) @ T2 @ ( set2 @ ( treeFI @ a ) @ ( sub @ a @ tra ) ) )
          & ( koenig488553731niteTr @ a @ T2 ) )
      @ ( set2 @ ( treeFI @ a ) @ ( sub @ a @ tra ) ) )
    & ( koenig488553731niteTr @ a
      @ @+[T2: treeFI @ a] :
          ( ( member2 @ ( treeFI @ a ) @ T2 @ ( set2 @ ( treeFI @ a ) @ ( sub @ a @ tra ) ) )
          & ( koenig488553731niteTr @ a @ T2 ) ) ) ) ).

% calculation
thf(fact_6_konigPath_Osimps_I2_J,axiom,
    ! [A: $tType,T3: treeFI @ A] :
      ( ( stl @ A @ ( koenig1103336060igPath @ A @ T3 ) )
      = ( koenig1103336060igPath @ A
        @ @+[Tr: treeFI @ A] :
            ( ( member2 @ ( treeFI @ A ) @ Tr @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ T3 ) ) )
            & ( koenig488553731niteTr @ A @ Tr ) ) ) ) ).

% konigPath.simps(2)
thf(fact_7_infiniteTr__sub,axiom,
    ! [A: $tType,Tr2: treeFI @ A] :
      ( ( koenig488553731niteTr @ A @ Tr2 )
     => ? [X: treeFI @ A] :
          ( ( member2 @ ( treeFI @ A ) @ X @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr2 ) ) )
          & ( koenig488553731niteTr @ A @ X ) ) ) ).

% infiniteTr_sub
thf(fact_8_infiniteTr_Ocases,axiom,
    ! [A: $tType,A2: treeFI @ A] :
      ( ( koenig488553731niteTr @ A @ A2 )
     => ~ ! [Tr3: treeFI @ A] :
            ( ( member2 @ ( treeFI @ A ) @ Tr3 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ A2 ) ) )
           => ~ ( koenig488553731niteTr @ A @ Tr3 ) ) ) ).

% infiniteTr.cases
thf(fact_9_infiniteTr_Osimps,axiom,
    ! [A: $tType] :
      ( ( koenig488553731niteTr @ A )
      = ( ^ [A3: treeFI @ A] :
          ? [Tr4: treeFI @ A,Tr: treeFI @ A] :
            ( ( A3 = Tr )
            & ( member2 @ ( treeFI @ A ) @ Tr4 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr ) ) )
            & ( koenig488553731niteTr @ A @ Tr4 ) ) ) ) ).

% infiniteTr.simps
thf(fact_10_infiniteTr__coind,axiom,
    ! [A: $tType,Phi: ( treeFI @ A ) > $o,Tr2: treeFI @ A] :
      ( ( Phi @ Tr2 )
     => ( ! [Tr5: treeFI @ A] :
            ( ( Phi @ Tr5 )
           => ? [X2: treeFI @ A] :
                ( ( member2 @ ( treeFI @ A ) @ X2 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr5 ) ) )
                & ( Phi @ X2 ) ) )
       => ( koenig488553731niteTr @ A @ Tr2 ) ) ) ).

% infiniteTr_coind
thf(fact_11_infiniteTr_Ointros,axiom,
    ! [A: $tType,Tr6: treeFI @ A,Tr2: treeFI @ A] :
      ( ( member2 @ ( treeFI @ A ) @ Tr6 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr2 ) ) )
     => ( ( koenig488553731niteTr @ A @ Tr6 )
       => ( koenig488553731niteTr @ A @ Tr2 ) ) ) ).

% infiniteTr.intros
thf(fact_12_infiniteTr_Ocoinduct,axiom,
    ! [A: $tType,X3: ( treeFI @ A ) > $o,X4: treeFI @ A] :
      ( ( X3 @ X4 )
     => ( ! [X: treeFI @ A] :
            ( ( X3 @ X )
           => ? [Tr7: treeFI @ A,Tr8: treeFI @ A] :
                ( ( X = Tr8 )
                & ( member2 @ ( treeFI @ A ) @ Tr7 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr8 ) ) )
                & ( ( X3 @ Tr7 )
                  | ( koenig488553731niteTr @ A @ Tr7 ) ) ) )
       => ( koenig488553731niteTr @ A @ X4 ) ) ) ).

% infiniteTr.coinduct
thf(fact_13_infiniteTr__strong__coind,axiom,
    ! [A: $tType,Phi: ( treeFI @ A ) > $o,Tr2: treeFI @ A] :
      ( ( Phi @ Tr2 )
     => ( ! [Tr5: treeFI @ A] :
            ( ( Phi @ Tr5 )
           => ? [X2: treeFI @ A] :
                ( ( member2 @ ( treeFI @ A ) @ X2 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr5 ) ) )
                & ( ( Phi @ X2 )
                  | ( koenig488553731niteTr @ A @ X2 ) ) ) )
       => ( koenig488553731niteTr @ A @ Tr2 ) ) ) ).

% infiniteTr_strong_coind
thf(fact_14_some__equality,axiom,
    ! [A: $tType,P: A > $o,A2: A] :
      ( ( P @ A2 )
     => ( ! [X: A] :
            ( ( P @ X )
           => ( X = A2 ) )
       => ( ( ^ [P2: A > $o] :
              @+[X5: A] : ( P2 @ X5 )
            @ P )
          = A2 ) ) ) ).

% some_equality
thf(fact_15_some__eq__trivial,axiom,
    ! [A: $tType,X4: A] :
      ( ( @+[Y: A] : ( Y = X4 ) )
      = X4 ) ).

% some_eq_trivial
thf(fact_16_some__sym__eq__trivial,axiom,
    ! [A: $tType,X4: A] :
      ( ( ^ [P2: A > $o] :
          @+[X5: A] : ( P2 @ X5 )
        @ ( ^ [Y2: A,Z: A] : ( Y2 = Z )
          @ X4 ) )
      = X4 ) ).

% some_sym_eq_trivial
thf(fact_17_properPath__sub,axiom,
    ! [A: $tType,As: stream @ A,Tr2: treeFI @ A,Phi: ( stream @ A ) > ( treeFI @ A ) > $o] :
      ( ( koenig1755522246erPath @ A @ As @ Tr2 )
     => ? [X: treeFI @ A] :
          ( ( member2 @ ( treeFI @ A ) @ X @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr2 ) ) )
          & ( ( Phi @ ( stl @ A @ As ) @ X )
            | ( koenig1755522246erPath @ A @ ( stl @ A @ As ) @ X ) ) ) ) ).

% properPath_sub
thf(fact_18_someI2,axiom,
    ! [A: $tType,P: A > $o,A2: A,Q: A > $o] :
      ( ( P @ A2 )
     => ( ! [X: A] :
            ( ( P @ X )
           => ( Q @ X ) )
       => ( Q
          @ ( ^ [P2: A > $o] :
              @+[X5: A] : ( P2 @ X5 )
            @ P ) ) ) ) ).

% someI2
thf(fact_19_someI__ex,axiom,
    ! [A: $tType,P: A > $o] :
      ( ? [X1: A] : ( P @ X1 )
     => ( P
        @ ( ^ [P2: A > $o] :
            @+[X5: A] : ( P2 @ X5 )
          @ P ) ) ) ).

% someI_ex
thf(fact_20_someI2__ex,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ? [X1: A] : ( P @ X1 )
     => ( ! [X: A] :
            ( ( P @ X )
           => ( Q @ X ) )
       => ( Q
          @ ( ^ [P2: A > $o] :
              @+[X5: A] : ( P2 @ X5 )
            @ P ) ) ) ) ).

% someI2_ex
thf(fact_21_someI2__bex,axiom,
    ! [A: $tType,A4: set @ A,P: A > $o,Q: A > $o] :
      ( ? [X2: A] :
          ( ( member2 @ A @ X2 @ A4 )
          & ( P @ X2 ) )
     => ( ! [X: A] :
            ( ( ( member2 @ A @ X @ A4 )
              & ( P @ X ) )
           => ( Q @ X ) )
       => ( Q
          @ @+[X6: A] :
              ( ( member2 @ A @ X6 @ A4 )
              & ( P @ X6 ) ) ) ) ) ).

% someI2_bex
thf(fact_22_some__eq__ex,axiom,
    ! [A: $tType,P: A > $o] :
      ( ( P
        @ ( ^ [P2: A > $o] :
            @+[X5: A] : ( P2 @ X5 )
          @ P ) )
      = ( ^ [P2: A > $o] :
          ? [X5: A] : ( P2 @ X5 )
        @ P ) ) ).

% some_eq_ex
thf(fact_23_some1__equality,axiom,
    ! [A: $tType,P: A > $o,A2: A] :
      ( ? [X2: A] :
          ( ( P @ X2 )
          & ! [Y3: A] :
              ( ( P @ Y3 )
             => ( Y3 = X2 ) ) )
     => ( ( P @ A2 )
       => ( ( ^ [P2: A > $o] :
              @+[X5: A] : ( P2 @ X5 )
            @ P )
          = A2 ) ) ) ).

% some1_equality
thf(fact_24_Nitpick_OEps__psimp,axiom,
    ! [A: $tType,P: A > $o,X4: A,Y4: A] :
      ( ( P @ X4 )
     => ( ~ ( P @ Y4 )
       => ( ( ( ^ [P2: A > $o] :
                @+[X5: A] : ( P2 @ X5 )
              @ P )
            = Y4 )
         => ( ( ^ [P2: A > $o] :
                @+[X5: A] : ( P2 @ X5 )
              @ P )
            = X4 ) ) ) ) ).

% Nitpick.Eps_psimp
thf(fact_25_someI,axiom,
    ! [A: $tType,P: A > $o,X4: A] :
      ( ( P @ X4 )
     => ( P
        @ ( ^ [P2: A > $o] :
            @+[X5: A] : ( P2 @ X5 )
          @ P ) ) ) ).

% someI
thf(fact_26_tfl__some,axiom,
    ! [A: $tType,P3: A > $o,X2: A] :
      ( ( P3 @ X2 )
     => ( P3
        @ ( ^ [P2: A > $o] :
            @+[X5: A] : ( P2 @ X5 )
          @ P3 ) ) ) ).

% tfl_some
thf(fact_27_konigPath_Ocode,axiom,
    ! [A: $tType] :
      ( ( koenig1103336060igPath @ A )
      = ( ^ [T4: treeFI @ A] :
            ( sCons @ A @ ( lab @ A @ T4 )
            @ ( koenig1103336060igPath @ A
              @ @+[Tr: treeFI @ A] :
                  ( ( member2 @ ( treeFI @ A ) @ Tr @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ T4 ) ) )
                  & ( koenig488553731niteTr @ A @ Tr ) ) ) ) ) ) ).

% konigPath.code
thf(fact_28_properPath__strong__coind,axiom,
    ! [A: $tType,Phi: ( stream @ A ) > ( treeFI @ A ) > $o,As: stream @ A,Tr2: treeFI @ A] :
      ( ( Phi @ As @ Tr2 )
     => ( ! [As2: stream @ A,Tr5: treeFI @ A] :
            ( ( Phi @ As2 @ Tr5 )
           => ( ( shd @ A @ As2 )
              = ( lab @ A @ Tr5 ) ) )
       => ( ! [As2: stream @ A,Tr5: treeFI @ A] :
              ( ( Phi @ As2 @ Tr5 )
             => ? [X2: treeFI @ A] :
                  ( ( member2 @ ( treeFI @ A ) @ X2 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr5 ) ) )
                  & ( ( Phi @ ( stl @ A @ As2 ) @ X2 )
                    | ( koenig1755522246erPath @ A @ ( stl @ A @ As2 ) @ X2 ) ) ) )
         => ( koenig1755522246erPath @ A @ As @ Tr2 ) ) ) ) ).

% properPath_strong_coind
thf(fact_29_properPath_Ocoinduct,axiom,
    ! [A: $tType,X3: ( stream @ A ) > ( treeFI @ A ) > $o,X4: stream @ A,Xa: treeFI @ A] :
      ( ( X3 @ X4 @ Xa )
     => ( ! [X: stream @ A,Xa2: treeFI @ A] :
            ( ( X3 @ X @ Xa2 )
           => ? [As3: stream @ A,Tr8: treeFI @ A,Tr7: treeFI @ A] :
                ( ( X = As3 )
                & ( Xa2 = Tr8 )
                & ( ( shd @ A @ As3 )
                  = ( lab @ A @ Tr8 ) )
                & ( member2 @ ( treeFI @ A ) @ Tr7 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr8 ) ) )
                & ( ( X3 @ ( stl @ A @ As3 ) @ Tr7 )
                  | ( koenig1755522246erPath @ A @ ( stl @ A @ As3 ) @ Tr7 ) ) ) )
       => ( koenig1755522246erPath @ A @ X4 @ Xa ) ) ) ).

% properPath.coinduct
thf(fact_30_properPath_Ointros,axiom,
    ! [A: $tType,As: stream @ A,Tr2: treeFI @ A,Tr6: treeFI @ A] :
      ( ( ( shd @ A @ As )
        = ( lab @ A @ Tr2 ) )
     => ( ( member2 @ ( treeFI @ A ) @ Tr6 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr2 ) ) )
       => ( ( koenig1755522246erPath @ A @ ( stl @ A @ As ) @ Tr6 )
         => ( koenig1755522246erPath @ A @ As @ Tr2 ) ) ) ) ).

% properPath.intros
thf(fact_31_properPath__coind,axiom,
    ! [A: $tType,Phi: ( stream @ A ) > ( treeFI @ A ) > $o,As: stream @ A,Tr2: treeFI @ A] :
      ( ( Phi @ As @ Tr2 )
     => ( ! [As2: stream @ A,Tr5: treeFI @ A] :
            ( ( Phi @ As2 @ Tr5 )
           => ( ( shd @ A @ As2 )
              = ( lab @ A @ Tr5 ) ) )
       => ( ! [As2: stream @ A,Tr5: treeFI @ A] :
              ( ( Phi @ As2 @ Tr5 )
             => ? [X2: treeFI @ A] :
                  ( ( member2 @ ( treeFI @ A ) @ X2 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr5 ) ) )
                  & ( Phi @ ( stl @ A @ As2 ) @ X2 ) ) )
         => ( koenig1755522246erPath @ A @ As @ Tr2 ) ) ) ) ).

% properPath_coind
thf(fact_32_properPath_Osimps,axiom,
    ! [A: $tType] :
      ( ( koenig1755522246erPath @ A )
      = ( ^ [A1: stream @ A,A22: treeFI @ A] :
          ? [As4: stream @ A,Tr: treeFI @ A,Tr4: treeFI @ A] :
            ( ( A1 = As4 )
            & ( A22 = Tr )
            & ( ( shd @ A @ As4 )
              = ( lab @ A @ Tr ) )
            & ( member2 @ ( treeFI @ A ) @ Tr4 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ Tr ) ) )
            & ( koenig1755522246erPath @ A @ ( stl @ A @ As4 ) @ Tr4 ) ) ) ) ).

% properPath.simps
thf(fact_33_properPath_Ocases,axiom,
    ! [A: $tType,A12: stream @ A,A23: treeFI @ A] :
      ( ( koenig1755522246erPath @ A @ A12 @ A23 )
     => ~ ( ( ( shd @ A @ A12 )
            = ( lab @ A @ A23 ) )
         => ! [Tr3: treeFI @ A] :
              ( ( member2 @ ( treeFI @ A ) @ Tr3 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ A23 ) ) )
             => ~ ( koenig1755522246erPath @ A @ ( stl @ A @ A12 ) @ Tr3 ) ) ) ) ).

% properPath.cases
thf(fact_34_univ__def,axiom,
    ! [A: $tType,B: $tType] :
      ( ( bNF_Greatest_univ @ B @ A )
      = ( ^ [F: B > A,X7: set @ B] :
            ( F
            @ @+[X6: B] : ( member2 @ B @ X6 @ X7 ) ) ) ) ).

% univ_def
thf(fact_35_treeFI_Oset__sel_I2_J,axiom,
    ! [A: $tType,X4: treeFI @ A,A2: treeFI @ A,Xa: A] :
      ( ( member2 @ ( treeFI @ A ) @ X4 @ ( set2 @ ( treeFI @ A ) @ ( sub @ A @ A2 ) ) )
     => ( ( member2 @ A @ Xa @ ( set_treeFI @ A @ X4 ) )
       => ( member2 @ A @ Xa @ ( set_treeFI @ A @ A2 ) ) ) ) ).

% treeFI.set_sel(2)
thf(fact_36_treeFI_Oset__sel_I1_J,axiom,
    ! [A: $tType,A2: treeFI @ A] : ( member2 @ A @ ( lab @ A @ A2 ) @ ( set_treeFI @ A @ A2 ) ) ).

% treeFI.set_sel(1)
thf(fact_37_properPath__shd__lab,axiom,
    ! [A: $tType,As: stream @ A,Tr2: treeFI @ A] :
      ( ( koenig1755522246erPath @ A @ As @ Tr2 )
     => ( ( shd @ A @ As )
        = ( lab @ A @ Tr2 ) ) ) ).

% properPath_shd_lab
thf(fact_38_treeFI_Oexpand,axiom,
    ! [A: $tType,TreeFI: treeFI @ A,TreeFI2: treeFI @ A] :
      ( ( ( ( lab @ A @ TreeFI )
          = ( lab @ A @ TreeFI2 ) )
        & ( ( sub @ A @ TreeFI )
          = ( sub @ A @ TreeFI2 ) ) )
     => ( TreeFI = TreeFI2 ) ) ).

% treeFI.expand
thf(fact_39_konigPath_Osimps_I1_J,axiom,
    ! [A: $tType,T3: treeFI @ A] :
      ( ( shd @ A @ ( koenig1103336060igPath @ A @ T3 ) )
      = ( lab @ A @ T3 ) ) ).

% konigPath.simps(1)
thf(fact_40_stream_Ocollapse,axiom,
    ! [A: $tType,Stream: stream @ A] :
      ( ( sCons @ A @ ( shd @ A @ Stream ) @ ( stl @ A @ Stream ) )
      = Stream ) ).

% stream.collapse
thf(fact_41_stream_Oexhaust__sel,axiom,
    ! [A: $tType,Stream: stream @ A] :
      ( Stream
      = ( sCons @ A @ ( shd @ A @ Stream ) @ ( stl @ A @ Stream ) ) ) ).

% stream.exhaust_sel
thf(fact_42_stream_Oinject,axiom,
    ! [A: $tType,X12: A,X22: stream @ A,Y1: A,Y22: stream @ A] :
      ( ( ( sCons @ A @ X12 @ X22 )
        = ( sCons @ A @ Y1 @ Y22 ) )
      = ( ( X12 = Y1 )
        & ( X22 = Y22 ) ) ) ).

% stream.inject
thf(fact_43_stream_Osel_I1_J,axiom,
    ! [A: $tType,X12: A,X22: stream @ A] :
      ( ( shd @ A @ ( sCons @ A @ X12 @ X22 ) )
      = X12 ) ).

% stream.sel(1)
thf(fact_44_stream_Osel_I2_J,axiom,
    ! [A: $tType,X12: A,X22: stream @ A] :
      ( ( stl @ A @ ( sCons @ A @ X12 @ X22 ) )
      = X22 ) ).

% stream.sel(2)
thf(fact_45_mem__Collect__eq,axiom,
    ! [A: $tType,A2: A,P: A > $o] :
      ( ( member2 @ A @ A2 @ ( collect @ A @ P ) )
      = ( P @ A2 ) ) ).

% mem_Collect_eq
thf(fact_46_Collect__mem__eq,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( collect @ A
        @ ^ [X6: A] : ( member2 @ A @ X6 @ A4 ) )
      = A4 ) ).

% Collect_mem_eq
thf(fact_47_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X: A] :
          ( ( P @ X )
          = ( Q @ X ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_48_ext,axiom,
    ! [B: $tType,A: $tType,F2: A > B,G: A > B] :
      ( ! [X: A] :
          ( ( F2 @ X )
          = ( G @ X ) )
     => ( F2 = G ) ) ).

% ext
thf(fact_49_stream_Oexpand,axiom,
    ! [A: $tType,Stream: stream @ A,Stream2: stream @ A] :
      ( ( ( ( shd @ A @ Stream )
          = ( shd @ A @ Stream2 ) )
        & ( ( stl @ A @ Stream )
          = ( stl @ A @ Stream2 ) ) )
     => ( Stream = Stream2 ) ) ).

% stream.expand
thf(fact_50_stream_Ocoinduct,axiom,
    ! [A: $tType,R: ( stream @ A ) > ( stream @ A ) > $o,Stream: stream @ A,Stream2: stream @ A] :
      ( ( R @ Stream @ Stream2 )
     => ( ! [Stream3: stream @ A,Stream4: stream @ A] :
            ( ( R @ Stream3 @ Stream4 )
           => ( ( ( shd @ A @ Stream3 )
                = ( shd @ A @ Stream4 ) )
              & ( R @ ( stl @ A @ Stream3 ) @ ( stl @ A @ Stream4 ) ) ) )
       => ( Stream = Stream2 ) ) ) ).

% stream.coinduct
thf(fact_51_stream_Ocoinduct__strong,axiom,
    ! [A: $tType,R: ( stream @ A ) > ( stream @ A ) > $o,Stream: stream @ A,Stream2: stream @ A] :
      ( ( R @ Stream @ Stream2 )
     => ( ! [Stream3: stream @ A,Stream4: stream @ A] :
            ( ( R @ Stream3 @ Stream4 )
           => ( ( ( shd @ A @ Stream3 )
                = ( shd @ A @ Stream4 ) )
              & ( ( R @ ( stl @ A @ Stream3 ) @ ( stl @ A @ Stream4 ) )
                | ( ( stl @ A @ Stream3 )
                  = ( stl @ A @ Stream4 ) ) ) ) )
       => ( Stream = Stream2 ) ) ) ).

% stream.coinduct_strong
thf(fact_52_treeFI_Ocase__eq__if,axiom,
    ! [B: $tType,A: $tType] :
      ( ( case_treeFI @ A @ B )
      = ( ^ [F: A > ( list @ ( treeFI @ A ) ) > B,TreeFI3: treeFI @ A] : ( F @ ( lab @ A @ TreeFI3 ) @ ( sub @ A @ TreeFI3 ) ) ) ) ).

% treeFI.case_eq_if
thf(fact_53_treeFI_Ocase__distrib,axiom,
    ! [B: $tType,C: $tType,A: $tType,H: B > C,F2: A > ( list @ ( treeFI @ A ) ) > B,TreeFI: treeFI @ A] :
      ( ( H @ ( case_treeFI @ A @ B @ F2 @ TreeFI ) )
      = ( case_treeFI @ A @ C
        @ ^ [X13: A,X23: list @ ( treeFI @ A )] : ( H @ ( F2 @ X13 @ X23 ) )
        @ TreeFI ) ) ).

% treeFI.case_distrib
thf(fact_54_treeFI_Osub__def,axiom,
    ! [A: $tType] :
      ( ( sub @ A )
      = ( case_treeFI @ A @ ( list @ ( treeFI @ A ) )
        @ ^ [X13: A,X23: list @ ( treeFI @ A )] : X23 ) ) ).

% treeFI.sub_def
thf(fact_55_lab__def,axiom,
    ! [A: $tType] :
      ( ( lab @ A )
      = ( case_treeFI @ A @ A
        @ ^ [X13: A,X23: list @ ( treeFI @ A )] : X13 ) ) ).

% lab_def
thf(fact_56_stream_Oexhaust,axiom,
    ! [A: $tType,Y4: stream @ A] :
      ~ ! [X14: A,X24: stream @ A] :
          ( Y4
         != ( sCons @ A @ X14 @ X24 ) ) ).

% stream.exhaust
thf(fact_57_smember__code,axiom,
    ! [A: $tType,X4: A,Y4: A,S: stream @ A] :
      ( ( smember @ A @ X4 @ ( sCons @ A @ Y4 @ S ) )
      = ( ( X4 != Y4 )
       => ( smember @ A @ X4 @ S ) ) ) ).

% smember_code
thf(fact_58_sinterleave_Ocode,axiom,
    ! [A: $tType] :
      ( ( sinterleave @ A )
      = ( ^ [S1: stream @ A,S2: stream @ A] : ( sCons @ A @ ( shd @ A @ S1 ) @ ( sinterleave @ A @ S2 @ ( stl @ A @ S1 ) ) ) ) ) ).

% sinterleave.code
thf(fact_59_stream_Osplit__sel__asm,axiom,
    ! [B: $tType,A: $tType,P: B > $o,F2: A > ( stream @ A ) > B,Stream: stream @ A] :
      ( ( P @ ( case_stream @ A @ B @ F2 @ Stream ) )
      = ( ~ ( ( Stream
              = ( sCons @ A @ ( shd @ A @ Stream ) @ ( stl @ A @ Stream ) ) )
            & ~ ( P @ ( F2 @ ( shd @ A @ Stream ) @ ( stl @ A @ Stream ) ) ) ) ) ) ).

% stream.split_sel_asm
thf(fact_60_stream_Osplit__sel,axiom,
    ! [B: $tType,A: $tType,P: B > $o,F2: A > ( stream @ A ) > B,Stream: stream @ A] :
      ( ( P @ ( case_stream @ A @ B @ F2 @ Stream ) )
      = ( ( Stream
          = ( sCons @ A @ ( shd @ A @ Stream ) @ ( stl @ A @ Stream ) ) )
       => ( P @ ( F2 @ ( shd @ A @ Stream ) @ ( stl @ A @ Stream ) ) ) ) ) ).

% stream.split_sel
thf(fact_61_smap2_Ocode,axiom,
    ! [C: $tType,B: $tType,A: $tType] :
      ( ( smap2 @ A @ B @ C )
      = ( ^ [F: A > B > C,S1: stream @ A,S2: stream @ B] : ( sCons @ C @ ( F @ ( shd @ A @ S1 ) @ ( shd @ B @ S2 ) ) @ ( smap2 @ A @ B @ C @ F @ ( stl @ A @ S1 ) @ ( stl @ B @ S2 ) ) ) ) ) ).

% smap2.code
thf(fact_62_treeFI_Osplit__sel__asm,axiom,
    ! [B: $tType,A: $tType,P: B > $o,F2: A > ( list @ ( treeFI @ A ) ) > B,TreeFI: treeFI @ A] :
      ( ( P @ ( case_treeFI @ A @ B @ F2 @ TreeFI ) )
      = ( ~ ( ( TreeFI
              = ( tree @ A @ ( lab @ A @ TreeFI ) @ ( sub @ A @ TreeFI ) ) )
            & ~ ( P @ ( F2 @ ( lab @ A @ TreeFI ) @ ( sub @ A @ TreeFI ) ) ) ) ) ) ).

% treeFI.split_sel_asm
thf(fact_63_treeFI_Osplit__sel,axiom,
    ! [B: $tType,A: $tType,P: B > $o,F2: A > ( list @ ( treeFI @ A ) ) > B,TreeFI: treeFI @ A] :
      ( ( P @ ( case_treeFI @ A @ B @ F2 @ TreeFI ) )
      = ( ( TreeFI
          = ( tree @ A @ ( lab @ A @ TreeFI ) @ ( sub @ A @ TreeFI ) ) )
       => ( P @ ( F2 @ ( lab @ A @ TreeFI ) @ ( sub @ A @ TreeFI ) ) ) ) ) ).

% treeFI.split_sel
thf(fact_64_stream_Ocase__eq__if,axiom,
    ! [B: $tType,A: $tType] :
      ( ( case_stream @ A @ B )
      = ( ^ [F: A > ( stream @ A ) > B,Stream5: stream @ A] : ( F @ ( shd @ A @ Stream5 ) @ ( stl @ A @ Stream5 ) ) ) ) ).

% stream.case_eq_if
thf(fact_65_treeFI_Oinject,axiom,
    ! [A: $tType,X12: A,X22: list @ ( treeFI @ A ),Y1: A,Y22: list @ ( treeFI @ A )] :
      ( ( ( tree @ A @ X12 @ X22 )
        = ( tree @ A @ Y1 @ Y22 ) )
      = ( ( X12 = Y1 )
        & ( X22 = Y22 ) ) ) ).

% treeFI.inject
thf(fact_66_treeFI_Ocollapse,axiom,
    ! [A: $tType,TreeFI: treeFI @ A] :
      ( ( tree @ A @ ( lab @ A @ TreeFI ) @ ( sub @ A @ TreeFI ) )
      = TreeFI ) ).

% treeFI.collapse
thf(fact_67_treeFI_Oexhaust,axiom,
    ! [A: $tType,Y4: treeFI @ A] :
      ~ ! [X14: A,X24: list @ ( treeFI @ A )] :
          ( Y4
         != ( tree @ A @ X14 @ X24 ) ) ).

% treeFI.exhaust
thf(fact_68_stream_Ocase__distrib,axiom,
    ! [B: $tType,C: $tType,A: $tType,H: B > C,F2: A > ( stream @ A ) > B,Stream: stream @ A] :
      ( ( H @ ( case_stream @ A @ B @ F2 @ Stream ) )
      = ( case_stream @ A @ C
        @ ^ [X13: A,X23: stream @ A] : ( H @ ( F2 @ X13 @ X23 ) )
        @ Stream ) ) ).

% stream.case_distrib
thf(fact_69_treeFI_Osel_I2_J,axiom,
    ! [A: $tType,X12: A,X22: list @ ( treeFI @ A )] :
      ( ( sub @ A @ ( tree @ A @ X12 @ X22 ) )
      = X22 ) ).

% treeFI.sel(2)
thf(fact_70_treeFI_Osel_I1_J,axiom,
    ! [A: $tType,X12: A,X22: list @ ( treeFI @ A )] :
      ( ( lab @ A @ ( tree @ A @ X12 @ X22 ) )
      = X12 ) ).

% treeFI.sel(1)
thf(fact_71_treeFI_Oset__intros_I1_J,axiom,
    ! [A: $tType,A12: A,A23: list @ ( treeFI @ A )] : ( member2 @ A @ A12 @ ( set_treeFI @ A @ ( tree @ A @ A12 @ A23 ) ) ) ).

% treeFI.set_intros(1)
thf(fact_72_smap2_Osimps_I2_J,axiom,
    ! [A: $tType,C: $tType,B: $tType,F2: A > B > C,S12: stream @ A,S22: stream @ B] :
      ( ( stl @ C @ ( smap2 @ A @ B @ C @ F2 @ S12 @ S22 ) )
      = ( smap2 @ A @ B @ C @ F2 @ ( stl @ A @ S12 ) @ ( stl @ B @ S22 ) ) ) ).

% smap2.simps(2)
thf(fact_73_treeFI_Ocase,axiom,
    ! [B: $tType,A: $tType,F2: A > ( list @ ( treeFI @ A ) ) > B,X12: A,X22: list @ ( treeFI @ A )] :
      ( ( case_treeFI @ A @ B @ F2 @ ( tree @ A @ X12 @ X22 ) )
      = ( F2 @ X12 @ X22 ) ) ).

% treeFI.case
thf(fact_74_smap2_Osimps_I1_J,axiom,
    ! [A: $tType,C: $tType,B: $tType,F2: A > B > C,S12: stream @ A,S22: stream @ B] :
      ( ( shd @ C @ ( smap2 @ A @ B @ C @ F2 @ S12 @ S22 ) )
      = ( F2 @ ( shd @ A @ S12 ) @ ( shd @ B @ S22 ) ) ) ).

% smap2.simps(1)
thf(fact_75_smap2__unfold,axiom,
    ! [B: $tType,A: $tType,C: $tType,F2: B > C > A,A2: B,S12: stream @ B,B2: C,S22: stream @ C] :
      ( ( smap2 @ B @ C @ A @ F2 @ ( sCons @ B @ A2 @ S12 ) @ ( sCons @ C @ B2 @ S22 ) )
      = ( sCons @ A @ ( F2 @ A2 @ B2 ) @ ( smap2 @ B @ C @ A @ F2 @ S12 @ S22 ) ) ) ).

% smap2_unfold
thf(fact_76_stream_Ocase,axiom,
    ! [B: $tType,A: $tType,F2: A > ( stream @ A ) > B,X12: A,X22: stream @ A] :
      ( ( case_stream @ A @ B @ F2 @ ( sCons @ A @ X12 @ X22 ) )
      = ( F2 @ X12 @ X22 ) ) ).

% stream.case
thf(fact_77_sinterleave_Osimps_I2_J,axiom,
    ! [A: $tType,S12: stream @ A,S22: stream @ A] :
      ( ( stl @ A @ ( sinterleave @ A @ S12 @ S22 ) )
      = ( sinterleave @ A @ S22 @ ( stl @ A @ S12 ) ) ) ).

% sinterleave.simps(2)
thf(fact_78_sinterleave_Osimps_I1_J,axiom,
    ! [A: $tType,S12: stream @ A,S22: stream @ A] :
      ( ( shd @ A @ ( sinterleave @ A @ S12 @ S22 ) )
      = ( shd @ A @ S12 ) ) ).

% sinterleave.simps(1)
thf(fact_79_sinterleave__code,axiom,
    ! [A: $tType,X4: A,S12: stream @ A,S22: stream @ A] :
      ( ( sinterleave @ A @ ( sCons @ A @ X4 @ S12 ) @ S22 )
      = ( sCons @ A @ X4 @ ( sinterleave @ A @ S22 @ S12 ) ) ) ).

% sinterleave_code
thf(fact_80_stl__def,axiom,
    ! [A: $tType] :
      ( ( stl @ A )
      = ( case_stream @ A @ ( stream @ A )
        @ ^ [X13: A,X23: stream @ A] : X23 ) ) ).

% stl_def
thf(fact_81_shd__def,axiom,
    ! [A: $tType] :
      ( ( shd @ A )
      = ( case_stream @ A @ A
        @ ^ [X13: A,X23: stream @ A] : X13 ) ) ).

% shd_def
thf(fact_82_treeFI_Oexhaust__sel,axiom,
    ! [A: $tType,TreeFI: treeFI @ A] :
      ( TreeFI
      = ( tree @ A @ ( lab @ A @ TreeFI ) @ ( sub @ A @ TreeFI ) ) ) ).

% treeFI.exhaust_sel
thf(fact_83_treeFI_Oset__induct,axiom,
    ! [A: $tType,X4: A,A2: treeFI @ A,P: A > ( treeFI @ A ) > $o] :
      ( ( member2 @ A @ X4 @ ( set_treeFI @ A @ A2 ) )
     => ( ! [Z1: A,Z2: list @ ( treeFI @ A )] : ( P @ Z1 @ ( tree @ A @ Z1 @ Z2 ) )
       => ( ! [Z1: A,Z2: list @ ( treeFI @ A ),Xa2: treeFI @ A,Xb: A] :
              ( ( member2 @ ( treeFI @ A ) @ Xa2 @ ( set2 @ ( treeFI @ A ) @ Z2 ) )
             => ( ( member2 @ A @ Xb @ ( set_treeFI @ A @ Xa2 ) )
               => ( ( P @ Xb @ Xa2 )
                 => ( P @ Xb @ ( tree @ A @ Z1 @ Z2 ) ) ) ) )
         => ( P @ X4 @ A2 ) ) ) ) ).

% treeFI.set_induct
thf(fact_84_treeFI_Oset__cases,axiom,
    ! [A: $tType,E: A,A2: treeFI @ A] :
      ( ( member2 @ A @ E @ ( set_treeFI @ A @ A2 ) )
     => ( ! [Z2: list @ ( treeFI @ A )] :
            ( A2
           != ( tree @ A @ E @ Z2 ) )
       => ~ ! [Z1: A,Z2: list @ ( treeFI @ A )] :
              ( ( A2
                = ( tree @ A @ Z1 @ Z2 ) )
             => ! [X: treeFI @ A] :
                  ( ( member2 @ ( treeFI @ A ) @ X @ ( set2 @ ( treeFI @ A ) @ Z2 ) )
                 => ~ ( member2 @ A @ E @ ( set_treeFI @ A @ X ) ) ) ) ) ) ).

% treeFI.set_cases
thf(fact_85_treeFI_Oset__intros_I2_J,axiom,
    ! [A: $tType,X4: treeFI @ A,A23: list @ ( treeFI @ A ),Xa: A,A12: A] :
      ( ( member2 @ ( treeFI @ A ) @ X4 @ ( set2 @ ( treeFI @ A ) @ A23 ) )
     => ( ( member2 @ A @ Xa @ ( set_treeFI @ A @ X4 ) )
       => ( member2 @ A @ Xa @ ( set_treeFI @ A @ ( tree @ A @ A12 @ A23 ) ) ) ) ) ).

% treeFI.set_intros(2)
thf(fact_86_sdrop__while_Osimps,axiom,
    ! [A: $tType] :
      ( ( sdrop_while @ A )
      = ( ^ [P4: A > $o,S3: stream @ A] : ( if @ ( stream @ A ) @ ( P4 @ ( shd @ A @ S3 ) ) @ ( sdrop_while @ A @ P4 @ ( stl @ A @ S3 ) ) @ S3 ) ) ) ).

% sdrop_while.simps
thf(fact_87_smap__ctr,axiom,
    ! [B: $tType,A: $tType,F2: B > A,S: stream @ B,X4: A,S4: stream @ A] :
      ( ( ( smap @ B @ A @ F2 @ S )
        = ( sCons @ A @ X4 @ S4 ) )
      = ( ( ( F2 @ ( shd @ B @ S ) )
          = X4 )
        & ( ( smap @ B @ A @ F2 @ ( stl @ B @ S ) )
          = S4 ) ) ) ).

% smap_ctr
thf(fact_88_trev_Osimps_I1_J,axiom,
    ! [A: $tType,T3: treeFI @ A] :
      ( ( lab @ A @ ( trev @ A @ T3 ) )
      = ( lab @ A @ T3 ) ) ).

% trev.simps(1)
thf(fact_89_streamsE,axiom,
    ! [A: $tType,S: stream @ A,A4: set @ A] :
      ( ( member2 @ ( stream @ A ) @ S @ ( streams @ A @ A4 ) )
     => ~ ( ( member2 @ A @ ( shd @ A @ S ) @ A4 )
         => ~ ( member2 @ ( stream @ A ) @ ( stl @ A @ S ) @ ( streams @ A @ A4 ) ) ) ) ).

% streamsE
thf(fact_90_in__streams,axiom,
    ! [A: $tType,S: stream @ A,S5: set @ A] :
      ( ( member2 @ ( stream @ A ) @ ( stl @ A @ S ) @ ( streams @ A @ S5 ) )
     => ( ( member2 @ A @ ( shd @ A @ S ) @ S5 )
       => ( member2 @ ( stream @ A ) @ S @ ( streams @ A @ S5 ) ) ) ) ).

% in_streams
thf(fact_91_stream__all__Stream,axiom,
    ! [A: $tType,P: A > $o,X4: A,X3: stream @ A] :
      ( ( stream_all @ A @ P @ ( sCons @ A @ X4 @ X3 ) )
      = ( ( P @ X4 )
        & ( stream_all @ A @ P @ X3 ) ) ) ).

% stream_all_Stream
thf(fact_92_treeFI_Ocoinduct__strong,axiom,
    ! [A: $tType,R: ( treeFI @ A ) > ( treeFI @ A ) > $o,TreeFI: treeFI @ A,TreeFI2: treeFI @ A] :
      ( ( R @ TreeFI @ TreeFI2 )
     => ( ! [TreeFI4: treeFI @ A,TreeFI5: treeFI @ A] :
            ( ( R @ TreeFI4 @ TreeFI5 )
           => ( ( ( lab @ A @ TreeFI4 )
                = ( lab @ A @ TreeFI5 ) )
              & ( list_all2 @ ( treeFI @ A ) @ ( treeFI @ A )
                @ ^ [TreeFIa: treeFI @ A,TreeFIa2: treeFI @ A] :
                    ( ( R @ TreeFIa @ TreeFIa2 )
                    | ( TreeFIa = TreeFIa2 ) )
                @ ( sub @ A @ TreeFI4 )
                @ ( sub @ A @ TreeFI5 ) ) ) )
       => ( TreeFI = TreeFI2 ) ) ) ).

% treeFI.coinduct_strong
thf(fact_93_stream_Omap__sel_I2_J,axiom,
    ! [B: $tType,A: $tType,F2: A > B,A2: stream @ A] :
      ( ( stl @ B @ ( smap @ A @ B @ F2 @ A2 ) )
      = ( smap @ A @ B @ F2 @ ( stl @ A @ A2 ) ) ) ).

% stream.map_sel(2)
thf(fact_94_stream_Omap__sel_I1_J,axiom,
    ! [B: $tType,A: $tType,F2: A > B,A2: stream @ A] :
      ( ( shd @ B @ ( smap @ A @ B @ F2 @ A2 ) )
      = ( F2 @ ( shd @ A @ A2 ) ) ) ).

% stream.map_sel(1)
thf(fact_95_smap__smap2,axiom,
    ! [C: $tType,A: $tType,B: $tType,D: $tType,F2: B > A,G: C > D > B,S12: stream @ C,S22: stream @ D] :
      ( ( smap @ B @ A @ F2 @ ( smap2 @ C @ D @ B @ G @ S12 @ S22 ) )
      = ( smap2 @ C @ D @ A
        @ ^ [X6: C,Y: D] : ( F2 @ ( G @ X6 @ Y ) )
        @ S12
        @ S22 ) ) ).

% smap_smap2
thf(fact_96_trev__trev,axiom,
    ! [A: $tType,Tr2: treeFI @ A] :
      ( ( trev @ A @ ( trev @ A @ Tr2 ) )
      = Tr2 ) ).

% trev_trev
thf(fact_97_stream_Omap__ident,axiom,
    ! [A: $tType,T3: stream @ A] :
      ( ( smap @ A @ A
        @ ^ [X6: A] : X6
        @ T3 )
      = T3 ) ).

% stream.map_ident
thf(fact_98_smap__streams,axiom,
    ! [A: $tType,B: $tType,S: stream @ A,A4: set @ A,F2: A > B,B3: set @ B] :
      ( ( member2 @ ( stream @ A ) @ S @ ( streams @ A @ A4 ) )
     => ( ! [X: A] :
            ( ( member2 @ A @ X @ A4 )
           => ( member2 @ B @ ( F2 @ X ) @ B3 ) )
       => ( member2 @ ( stream @ B ) @ ( smap @ A @ B @ F2 @ S ) @ ( streams @ B @ B3 ) ) ) ) ).

% smap_streams
thf(fact_99_stream_Omap,axiom,
    ! [B: $tType,A: $tType,F2: A > B,X12: A,X22: stream @ A] :
      ( ( smap @ A @ B @ F2 @ ( sCons @ A @ X12 @ X22 ) )
      = ( sCons @ B @ ( F2 @ X12 ) @ ( smap @ A @ B @ F2 @ X22 ) ) ) ).

% stream.map
thf(fact_100_streams__stl,axiom,
    ! [A: $tType,S: stream @ A,A4: set @ A] :
      ( ( member2 @ ( stream @ A ) @ S @ ( streams @ A @ A4 ) )
     => ( member2 @ ( stream @ A ) @ ( stl @ A @ S ) @ ( streams @ A @ A4 ) ) ) ).

% streams_stl
thf(fact_101_streams__shd,axiom,
    ! [A: $tType,S: stream @ A,A4: set @ A] :
      ( ( member2 @ ( stream @ A ) @ S @ ( streams @ A @ A4 ) )
     => ( member2 @ A @ ( shd @ A @ S ) @ A4 ) ) ).

% streams_shd
thf(fact_102_streams_Ocases,axiom,
    ! [A: $tType,A2: stream @ A,A4: set @ A] :
      ( ( member2 @ ( stream @ A ) @ A2 @ ( streams @ A @ A4 ) )
     => ~ ! [A5: A,S6: stream @ A] :
            ( ( A2
              = ( sCons @ A @ A5 @ S6 ) )
           => ( ( member2 @ A @ A5 @ A4 )
             => ~ ( member2 @ ( stream @ A ) @ S6 @ ( streams @ A @ A4 ) ) ) ) ) ).

% streams.cases
thf(fact_103_streams_Osimps,axiom,
    ! [A: $tType,A2: stream @ A,A4: set @ A] :
      ( ( member2 @ ( stream @ A ) @ A2 @ ( streams @ A @ A4 ) )
      = ( ? [A3: A,S3: stream @ A] :
            ( ( A2
              = ( sCons @ A @ A3 @ S3 ) )
            & ( member2 @ A @ A3 @ A4 )
            & ( member2 @ ( stream @ A ) @ S3 @ ( streams @ A @ A4 ) ) ) ) ) ).

% streams.simps
thf(fact_104_streams__Stream,axiom,
    ! [A: $tType,X4: A,S: stream @ A,A4: set @ A] :
      ( ( member2 @ ( stream @ A ) @ ( sCons @ A @ X4 @ S ) @ ( streams @ A @ A4 ) )
      = ( ( member2 @ A @ X4 @ A4 )
        & ( member2 @ ( stream @ A ) @ S @ ( streams @ A @ A4 ) ) ) ) ).

% streams_Stream
thf(fact_105_streams_Ocoinduct,axiom,
    ! [A: $tType,X3: ( stream @ A ) > $o,X4: stream @ A,A4: set @ A] :
      ( ( X3 @ X4 )
     => ( ! [X: stream @ A] :
            ( ( X3 @ X )
           => ? [A6: A,S7: stream @ A] :
                ( ( X
                  = ( sCons @ A @ A6 @ S7 ) )
                & ( member2 @ A @ A6 @ A4 )
                & ( ( X3 @ S7 )
                  | ( member2 @ ( stream @ A ) @ S7 @ ( streams @ A @ A4 ) ) ) ) )
       => ( member2 @ ( stream @ A ) @ X4 @ ( streams @ A @ A4 ) ) ) ) ).

% streams.coinduct
thf(fact_106_sdrop__while__SCons,axiom,
    ! [A: $tType,P: A > $o,A2: A,S: stream @ A] :
      ( ( ( P @ A2 )
       => ( ( sdrop_while @ A @ P @ ( sCons @ A @ A2 @ S ) )
          = ( sdrop_while @ A @ P @ S ) ) )
      & ( ~ ( P @ A2 )
       => ( ( sdrop_while @ A @ P @ ( sCons @ A @ A2 @ S ) )
          = ( sCons @ A @ A2 @ S ) ) ) ) ).

% sdrop_while_SCons
thf(fact_107_treeFI_Ocoinduct,axiom,
    ! [A: $tType,R: ( treeFI @ A ) > ( treeFI @ A ) > $o,TreeFI: treeFI @ A,TreeFI2: treeFI @ A] :
      ( ( R @ TreeFI @ TreeFI2 )
     => ( ! [TreeFI4: treeFI @ A,TreeFI5: treeFI @ A] :
            ( ( R @ TreeFI4 @ TreeFI5 )
           => ( ( ( lab @ A @ TreeFI4 )
                = ( lab @ A @ TreeFI5 ) )
              & ( list_all2 @ ( treeFI @ A ) @ ( treeFI @ A ) @ R @ ( sub @ A @ TreeFI4 ) @ ( sub @ A @ TreeFI5 ) ) ) )
       => ( TreeFI = TreeFI2 ) ) ) ).

% treeFI.coinduct
thf(fact_108_list__all2__same,axiom,
    ! [A: $tType,P: A > A > $o,Xs: list @ A] :
      ( ( list_all2 @ A @ A @ P @ Xs @ Xs )
      = ( ! [X6: A] :
            ( ( member2 @ A @ X6 @ ( set2 @ A @ Xs ) )
           => ( P @ X6 @ X6 ) ) ) ) ).

% list_all2_same
thf(fact_109_list_Orel__cong,axiom,
    ! [A: $tType,B: $tType,X4: list @ A,Ya: list @ A,Y4: list @ B,Xa: list @ B,R: A > B > $o,Ra: A > B > $o] :
      ( ( X4 = Ya )
     => ( ( Y4 = Xa )
       => ( ! [Z3: A,Yb: B] :
              ( ( member2 @ A @ Z3 @ ( set2 @ A @ Ya ) )
             => ( ( member2 @ B @ Yb @ ( set2 @ B @ Xa ) )
               => ( ( R @ Z3 @ Yb )
                  = ( Ra @ Z3 @ Yb ) ) ) )
         => ( ( list_all2 @ A @ B @ R @ X4 @ Y4 )
            = ( list_all2 @ A @ B @ Ra @ Ya @ Xa ) ) ) ) ) ).

% list.rel_cong
thf(fact_110_list_Orel__mono__strong,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o,X4: list @ A,Y4: list @ B,Ra: A > B > $o] :
      ( ( list_all2 @ A @ B @ R @ X4 @ Y4 )
     => ( ! [Z3: A,Yb: B] :
            ( ( member2 @ A @ Z3 @ ( set2 @ A @ X4 ) )
           => ( ( member2 @ B @ Yb @ ( set2 @ B @ Y4 ) )
             => ( ( R @ Z3 @ Yb )
               => ( Ra @ Z3 @ Yb ) ) ) )
       => ( list_all2 @ A @ B @ Ra @ X4 @ Y4 ) ) ) ).

% list.rel_mono_strong
thf(fact_111_list_Orel__refl__strong,axiom,
    ! [A: $tType,X4: list @ A,Ra: A > A > $o] :
      ( ! [Z3: A] :
          ( ( member2 @ A @ Z3 @ ( set2 @ A @ X4 ) )
         => ( Ra @ Z3 @ Z3 ) )
     => ( list_all2 @ A @ A @ Ra @ X4 @ X4 ) ) ).

% list.rel_refl_strong
thf(fact_112_treeFI_Orel__coinduct,axiom,
    ! [A: $tType,B: $tType,P: ( treeFI @ A ) > ( treeFI @ B ) > $o,X4: treeFI @ A,Y4: treeFI @ B,R: A > B > $o] :
      ( ( P @ X4 @ Y4 )
     => ( ! [TreeFI4: treeFI @ A,TreeFI5: treeFI @ B] :
            ( ( P @ TreeFI4 @ TreeFI5 )
           => ( ( R @ ( lab @ A @ TreeFI4 ) @ ( lab @ B @ TreeFI5 ) )
              & ( list_all2 @ ( treeFI @ A ) @ ( treeFI @ B ) @ P @ ( sub @ A @ TreeFI4 ) @ ( sub @ B @ TreeFI5 ) ) ) )
       => ( rel_treeFI @ A @ B @ R @ X4 @ Y4 ) ) ) ).

% treeFI.rel_coinduct
thf(fact_113_treeFI_Orel__inject,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o,X12: A,X22: list @ ( treeFI @ A ),Y1: B,Y22: list @ ( treeFI @ B )] :
      ( ( rel_treeFI @ A @ B @ R @ ( tree @ A @ X12 @ X22 ) @ ( tree @ B @ Y1 @ Y22 ) )
      = ( ( R @ X12 @ Y1 )
        & ( list_all2 @ ( treeFI @ A ) @ ( treeFI @ B ) @ ( rel_treeFI @ A @ B @ R ) @ X22 @ Y22 ) ) ) ).

% treeFI.rel_inject
thf(fact_114_treeFI_Orel__eq,axiom,
    ! [A: $tType] :
      ( ( rel_treeFI @ A @ A
        @ ^ [Y2: A,Z: A] : ( Y2 = Z ) )
      = ( ^ [Y2: treeFI @ A,Z: treeFI @ A] : ( Y2 = Z ) ) ) ).

% treeFI.rel_eq
thf(fact_115_treeFI_Orel__refl,axiom,
    ! [B: $tType,Ra: B > B > $o,X4: treeFI @ B] :
      ( ! [X: B] : ( Ra @ X @ X )
     => ( rel_treeFI @ B @ B @ Ra @ X4 @ X4 ) ) ).

% treeFI.rel_refl
thf(fact_116_treeFI_Orel__refl__strong,axiom,
    ! [A: $tType,X4: treeFI @ A,Ra: A > A > $o] :
      ( ! [Z3: A] :
          ( ( member2 @ A @ Z3 @ ( set_treeFI @ A @ X4 ) )
         => ( Ra @ Z3 @ Z3 ) )
     => ( rel_treeFI @ A @ A @ Ra @ X4 @ X4 ) ) ).

% treeFI.rel_refl_strong
thf(fact_117_treeFI_Orel__mono__strong,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o,X4: treeFI @ A,Y4: treeFI @ B,Ra: A > B > $o] :
      ( ( rel_treeFI @ A @ B @ R @ X4 @ Y4 )
     => ( ! [Z3: A,Yb: B] :
            ( ( member2 @ A @ Z3 @ ( set_treeFI @ A @ X4 ) )
           => ( ( member2 @ B @ Yb @ ( set_treeFI @ B @ Y4 ) )
             => ( ( R @ Z3 @ Yb )
               => ( Ra @ Z3 @ Yb ) ) ) )
       => ( rel_treeFI @ A @ B @ Ra @ X4 @ Y4 ) ) ) ).

% treeFI.rel_mono_strong
thf(fact_118_treeFI_Orel__cong,axiom,
    ! [A: $tType,B: $tType,X4: treeFI @ A,Ya: treeFI @ A,Y4: treeFI @ B,Xa: treeFI @ B,R: A > B > $o,Ra: A > B > $o] :
      ( ( X4 = Ya )
     => ( ( Y4 = Xa )
       => ( ! [Z3: A,Yb: B] :
              ( ( member2 @ A @ Z3 @ ( set_treeFI @ A @ Ya ) )
             => ( ( member2 @ B @ Yb @ ( set_treeFI @ B @ Xa ) )
               => ( ( R @ Z3 @ Yb )
                  = ( Ra @ Z3 @ Yb ) ) ) )
         => ( ( rel_treeFI @ A @ B @ R @ X4 @ Y4 )
            = ( rel_treeFI @ A @ B @ Ra @ Ya @ Xa ) ) ) ) ) ).

% treeFI.rel_cong
thf(fact_119_treeFI_Orel__intros,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o,X12: A,Y1: B,X22: list @ ( treeFI @ A ),Y22: list @ ( treeFI @ B )] :
      ( ( R @ X12 @ Y1 )
     => ( ( list_all2 @ ( treeFI @ A ) @ ( treeFI @ B ) @ ( rel_treeFI @ A @ B @ R ) @ X22 @ Y22 )
       => ( rel_treeFI @ A @ B @ R @ ( tree @ A @ X12 @ X22 ) @ ( tree @ B @ Y1 @ Y22 ) ) ) ) ).

% treeFI.rel_intros
thf(fact_120_treeFI_Orel__cases,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o,A2: treeFI @ A,B2: treeFI @ B] :
      ( ( rel_treeFI @ A @ B @ R @ A2 @ B2 )
     => ~ ! [X1a: A,X2a: list @ ( treeFI @ A )] :
            ( ( A2
              = ( tree @ A @ X1a @ X2a ) )
           => ! [Y1a: B,Y2a: list @ ( treeFI @ B )] :
                ( ( B2
                  = ( tree @ B @ Y1a @ Y2a ) )
               => ( ( R @ X1a @ Y1a )
                 => ~ ( list_all2 @ ( treeFI @ A ) @ ( treeFI @ B ) @ ( rel_treeFI @ A @ B @ R ) @ X2a @ Y2a ) ) ) ) ) ).

% treeFI.rel_cases
thf(fact_121_list_Orel__refl,axiom,
    ! [B: $tType,Ra: B > B > $o,X4: list @ B] :
      ( ! [X: B] : ( Ra @ X @ X )
     => ( list_all2 @ B @ B @ Ra @ X4 @ X4 ) ) ).

% list.rel_refl
thf(fact_122_list__all2__antisym,axiom,
    ! [A: $tType,P: A > A > $o,Q: A > A > $o,Xs: list @ A,Ys: list @ A] :
      ( ! [X: A,Y3: A] :
          ( ( P @ X @ Y3 )
         => ( ( Q @ Y3 @ X )
           => ( X = Y3 ) ) )
     => ( ( list_all2 @ A @ A @ P @ Xs @ Ys )
       => ( ( list_all2 @ A @ A @ Q @ Ys @ Xs )
         => ( Xs = Ys ) ) ) ) ).

% list_all2_antisym
thf(fact_123_list_Orel__eq,axiom,
    ! [A: $tType] :
      ( ( list_all2 @ A @ A
        @ ^ [Y2: A,Z: A] : ( Y2 = Z ) )
      = ( ^ [Y2: list @ A,Z: list @ A] : ( Y2 = Z ) ) ) ).

% list.rel_eq
thf(fact_124_list__all2__trans,axiom,
    ! [B: $tType,A: $tType,C: $tType,P1: A > B > $o,P22: B > C > $o,P32: A > C > $o,As: list @ A,Bs: list @ B,Cs: list @ C] :
      ( ! [A5: A,B4: B,C2: C] :
          ( ( P1 @ A5 @ B4 )
         => ( ( P22 @ B4 @ C2 )
           => ( P32 @ A5 @ C2 ) ) )
     => ( ( list_all2 @ A @ B @ P1 @ As @ Bs )
       => ( ( list_all2 @ B @ C @ P22 @ Bs @ Cs )
         => ( list_all2 @ A @ C @ P32 @ As @ Cs ) ) ) ) ).

% list_all2_trans
thf(fact_125_list__all2__refl,axiom,
    ! [A: $tType,P: A > A > $o,Xs: list @ A] :
      ( ! [X: A] : ( P @ X @ X )
     => ( list_all2 @ A @ A @ P @ Xs @ Xs ) ) ).

% list_all2_refl
thf(fact_126_list__all2__mono,axiom,
    ! [A: $tType,B: $tType,P: A > B > $o,Xs: list @ A,Ys: list @ B,Q: A > B > $o] :
      ( ( list_all2 @ A @ B @ P @ Xs @ Ys )
     => ( ! [Xs2: A,Ys2: B] :
            ( ( P @ Xs2 @ Ys2 )
           => ( Q @ Xs2 @ Ys2 ) )
       => ( list_all2 @ A @ B @ Q @ Xs @ Ys ) ) ) ).

% list_all2_mono
thf(fact_127_list__all2__eq,axiom,
    ! [A: $tType] :
      ( ( ^ [Y2: list @ A,Z: list @ A] : ( Y2 = Z ) )
      = ( list_all2 @ A @ A
        @ ^ [Y2: A,Z: A] : ( Y2 = Z ) ) ) ).

% list_all2_eq
thf(fact_128_treeFI_Orel__sel,axiom,
    ! [B: $tType,A: $tType] :
      ( ( rel_treeFI @ A @ B )
      = ( ^ [R2: A > B > $o,A3: treeFI @ A,B5: treeFI @ B] :
            ( ( R2 @ ( lab @ A @ A3 ) @ ( lab @ B @ B5 ) )
            & ( list_all2 @ ( treeFI @ A ) @ ( treeFI @ B ) @ ( rel_treeFI @ A @ B @ R2 ) @ ( sub @ A @ A3 ) @ ( sub @ B @ B5 ) ) ) ) ) ).

% treeFI.rel_sel
thf(fact_129_treeFI_Osel__transfer_I2_J,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o] : ( bNF_rel_fun @ ( treeFI @ A ) @ ( treeFI @ B ) @ ( list @ ( treeFI @ A ) ) @ ( list @ ( treeFI @ B ) ) @ ( rel_treeFI @ A @ B @ R ) @ ( list_all2 @ ( treeFI @ A ) @ ( treeFI @ B ) @ ( rel_treeFI @ A @ B @ R ) ) @ ( sub @ A ) @ ( sub @ B ) ) ).

% treeFI.sel_transfer(2)
thf(fact_130_in__set__member,axiom,
    ! [A: $tType,X4: A,Xs: list @ A] :
      ( ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
      = ( member @ A @ Xs @ X4 ) ) ).

% in_set_member
thf(fact_131_streams__def,axiom,
    ! [A: $tType] :
      ( ( streams @ A )
      = ( ^ [A7: set @ A] :
            ( collect @ ( stream @ A )
            @ ( streamsp @ A
              @ ^ [X6: A] : ( member2 @ A @ X6 @ A7 ) ) ) ) ) ).

% streams_def
thf(fact_132_streamsp__streams__eq,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( streamsp @ A
        @ ^ [X6: A] : ( member2 @ A @ X6 @ A4 ) )
      = ( ^ [X6: stream @ A] : ( member2 @ ( stream @ A ) @ X6 @ ( streams @ A @ A4 ) ) ) ) ).

% streamsp_streams_eq
thf(fact_133_product__lists__set,axiom,
    ! [A: $tType,Xss: list @ ( list @ A )] :
      ( ( set2 @ ( list @ A ) @ ( product_lists @ A @ Xss ) )
      = ( collect @ ( list @ A )
        @ ^ [Xs3: list @ A] :
            ( list_all2 @ A @ ( list @ A )
            @ ^ [X6: A,Ys3: list @ A] : ( member2 @ A @ X6 @ ( set2 @ A @ Ys3 ) )
            @ Xs3
            @ Xss ) ) ) ).

% product_lists_set
thf(fact_134_treeFI_Osel__transfer_I1_J,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o] : ( bNF_rel_fun @ ( treeFI @ A ) @ ( treeFI @ B ) @ A @ B @ ( rel_treeFI @ A @ B @ R ) @ R @ ( lab @ A ) @ ( lab @ B ) ) ).

% treeFI.sel_transfer(1)
thf(fact_135_streamsp_Ocases,axiom,
    ! [A: $tType,A4: A > $o,A2: stream @ A] :
      ( ( streamsp @ A @ A4 @ A2 )
     => ~ ! [A5: A,S6: stream @ A] :
            ( ( A2
              = ( sCons @ A @ A5 @ S6 ) )
           => ( ( A4 @ A5 )
             => ~ ( streamsp @ A @ A4 @ S6 ) ) ) ) ).

% streamsp.cases
thf(fact_136_streamsp_Osimps,axiom,
    ! [A: $tType] :
      ( ( streamsp @ A )
      = ( ^ [A7: A > $o,A3: stream @ A] :
          ? [B5: A,S3: stream @ A] :
            ( ( A3
              = ( sCons @ A @ B5 @ S3 ) )
            & ( A7 @ B5 )
            & ( streamsp @ A @ A7 @ S3 ) ) ) ) ).

% streamsp.simps
thf(fact_137_streamsp_Ocoinduct,axiom,
    ! [A: $tType,X3: ( stream @ A ) > $o,X4: stream @ A,A4: A > $o] :
      ( ( X3 @ X4 )
     => ( ! [X: stream @ A] :
            ( ( X3 @ X )
           => ? [A6: A,S7: stream @ A] :
                ( ( X
                  = ( sCons @ A @ A6 @ S7 ) )
                & ( A4 @ A6 )
                & ( ( X3 @ S7 )
                  | ( streamsp @ A @ A4 @ S7 ) ) ) )
       => ( streamsp @ A @ A4 @ X4 ) ) ) ).

% streamsp.coinduct
thf(fact_138_list_Orec__transfer,axiom,
    ! [C: $tType,A: $tType,B: $tType,D: $tType,S5: C > D > $o,R: A > B > $o] : ( bNF_rel_fun @ C @ D @ ( ( A > ( list @ A ) > C > C ) > ( list @ A ) > C ) @ ( ( B > ( list @ B ) > D > D ) > ( list @ B ) > D ) @ S5 @ ( bNF_rel_fun @ ( A > ( list @ A ) > C > C ) @ ( B > ( list @ B ) > D > D ) @ ( ( list @ A ) > C ) @ ( ( list @ B ) > D ) @ ( bNF_rel_fun @ A @ B @ ( ( list @ A ) > C > C ) @ ( ( list @ B ) > D > D ) @ R @ ( bNF_rel_fun @ ( list @ A ) @ ( list @ B ) @ ( C > C ) @ ( D > D ) @ ( list_all2 @ A @ B @ R ) @ ( bNF_rel_fun @ C @ D @ C @ D @ S5 @ S5 ) ) ) @ ( bNF_rel_fun @ ( list @ A ) @ ( list @ B ) @ C @ D @ ( list_all2 @ A @ B @ R ) @ S5 ) ) @ ( rec_list @ C @ A ) @ ( rec_list @ D @ B ) ) ).

% list.rec_transfer
thf(fact_139_foldl__transfer,axiom,
    ! [A: $tType,B: $tType,D: $tType,C: $tType,B3: A > C > $o,A4: B > D > $o] : ( bNF_rel_fun @ ( A > B > A ) @ ( C > D > C ) @ ( A > ( list @ B ) > A ) @ ( C > ( list @ D ) > C ) @ ( bNF_rel_fun @ A @ C @ ( B > A ) @ ( D > C ) @ B3 @ ( bNF_rel_fun @ B @ D @ A @ C @ A4 @ B3 ) ) @ ( bNF_rel_fun @ A @ C @ ( ( list @ B ) > A ) @ ( ( list @ D ) > C ) @ B3 @ ( bNF_rel_fun @ ( list @ B ) @ ( list @ D ) @ A @ C @ ( list_all2 @ B @ D @ A4 ) @ B3 ) ) @ ( foldl @ A @ B ) @ ( foldl @ C @ D ) ) ).

% foldl_transfer
thf(fact_140_sfilter_Ocode,axiom,
    ! [A: $tType] :
      ( ( sfilter @ A )
      = ( ^ [P4: A > $o,S3: stream @ A] : ( sCons @ A @ ( shd @ A @ ( sdrop_while @ A @ ( comp @ $o @ $o @ A @ (~) @ P4 ) @ S3 ) ) @ ( sfilter @ A @ P4 @ ( stl @ A @ ( sdrop_while @ A @ ( comp @ $o @ $o @ A @ (~) @ P4 ) @ S3 ) ) ) ) ) ) ).

% sfilter.code
thf(fact_141_in__set__insert,axiom,
    ! [A: $tType,X4: A,Xs: list @ A] :
      ( ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
     => ( ( insert @ A @ X4 @ Xs )
        = Xs ) ) ).

% in_set_insert
thf(fact_142_treeFI_Ocase__transfer,axiom,
    ! [A: $tType,C: $tType,D: $tType,B: $tType,R: A > B > $o,S5: C > D > $o] : ( bNF_rel_fun @ ( A > ( list @ ( treeFI @ A ) ) > C ) @ ( B > ( list @ ( treeFI @ B ) ) > D ) @ ( ( treeFI @ A ) > C ) @ ( ( treeFI @ B ) > D ) @ ( bNF_rel_fun @ A @ B @ ( ( list @ ( treeFI @ A ) ) > C ) @ ( ( list @ ( treeFI @ B ) ) > D ) @ R @ ( bNF_rel_fun @ ( list @ ( treeFI @ A ) ) @ ( list @ ( treeFI @ B ) ) @ C @ D @ ( list_all2 @ ( treeFI @ A ) @ ( treeFI @ B ) @ ( rel_treeFI @ A @ B @ R ) ) @ S5 ) ) @ ( bNF_rel_fun @ ( treeFI @ A ) @ ( treeFI @ B ) @ C @ D @ ( rel_treeFI @ A @ B @ R ) @ S5 ) @ ( case_treeFI @ A @ C ) @ ( case_treeFI @ B @ D ) ) ).

% treeFI.case_transfer
thf(fact_143_list_Orel__transfer,axiom,
    ! [A: $tType,B: $tType,D: $tType,C: $tType,Sa: A > C > $o,Sc: B > D > $o] :
      ( bNF_rel_fun @ ( A > B > $o ) @ ( C > D > $o ) @ ( ( list @ A ) > ( list @ B ) > $o ) @ ( ( list @ C ) > ( list @ D ) > $o )
      @ ( bNF_rel_fun @ A @ C @ ( B > $o ) @ ( D > $o ) @ Sa
        @ ( bNF_rel_fun @ B @ D @ $o @ $o @ Sc
          @ ^ [Y2: $o,Z: $o] : ( Y2 = Z ) ) )
      @ ( bNF_rel_fun @ ( list @ A ) @ ( list @ C ) @ ( ( list @ B ) > $o ) @ ( ( list @ D ) > $o ) @ ( list_all2 @ A @ C @ Sa )
        @ ( bNF_rel_fun @ ( list @ B ) @ ( list @ D ) @ $o @ $o @ ( list_all2 @ B @ D @ Sc )
          @ ^ [Y2: $o,Z: $o] : ( Y2 = Z ) ) )
      @ ( list_all2 @ A @ B )
      @ ( list_all2 @ C @ D ) ) ).

% list.rel_transfer
thf(fact_144_treeFI_Orel__transfer,axiom,
    ! [A: $tType,B: $tType,D: $tType,C: $tType,Sa: A > C > $o,Sc: B > D > $o] :
      ( bNF_rel_fun @ ( A > B > $o ) @ ( C > D > $o ) @ ( ( treeFI @ A ) > ( treeFI @ B ) > $o ) @ ( ( treeFI @ C ) > ( treeFI @ D ) > $o )
      @ ( bNF_rel_fun @ A @ C @ ( B > $o ) @ ( D > $o ) @ Sa
        @ ( bNF_rel_fun @ B @ D @ $o @ $o @ Sc
          @ ^ [Y2: $o,Z: $o] : ( Y2 = Z ) ) )
      @ ( bNF_rel_fun @ ( treeFI @ A ) @ ( treeFI @ C ) @ ( ( treeFI @ B ) > $o ) @ ( ( treeFI @ D ) > $o ) @ ( rel_treeFI @ A @ C @ Sa )
        @ ( bNF_rel_fun @ ( treeFI @ B ) @ ( treeFI @ D ) @ $o @ $o @ ( rel_treeFI @ B @ D @ Sc )
          @ ^ [Y2: $o,Z: $o] : ( Y2 = Z ) ) )
      @ ( rel_treeFI @ A @ B )
      @ ( rel_treeFI @ C @ D ) ) ).

% treeFI.rel_transfer
thf(fact_145_treeFI_Odisc__transfer,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o] :
      ( bNF_rel_fun @ ( treeFI @ A ) @ ( treeFI @ B ) @ $o @ $o @ ( rel_treeFI @ A @ B @ R )
      @ ^ [Y2: $o,Z: $o] : ( Y2 = Z )
      @ ^ [TreeFI3: treeFI @ A] : ( TreeFI3 = TreeFI3 )
      @ ^ [TreeFI3: treeFI @ B] : ( TreeFI3 = TreeFI3 ) ) ).

% treeFI.disc_transfer
thf(fact_146_stream_Omap__comp,axiom,
    ! [B: $tType,C: $tType,A: $tType,G: B > C,F2: A > B,V: stream @ A] :
      ( ( smap @ B @ C @ G @ ( smap @ A @ B @ F2 @ V ) )
      = ( smap @ A @ C @ ( comp @ B @ C @ A @ G @ F2 ) @ V ) ) ).

% stream.map_comp
thf(fact_147_sfilter_Osimps_I2_J,axiom,
    ! [A: $tType,P: A > $o,S: stream @ A] :
      ( ( stl @ A @ ( sfilter @ A @ P @ S ) )
      = ( sfilter @ A @ P @ ( stl @ A @ ( sdrop_while @ A @ ( comp @ $o @ $o @ A @ (~) @ P ) @ S ) ) ) ) ).

% sfilter.simps(2)
thf(fact_148_sfilter_Osimps_I1_J,axiom,
    ! [A: $tType,P: A > $o,S: stream @ A] :
      ( ( shd @ A @ ( sfilter @ A @ P @ S ) )
      = ( shd @ A @ ( sdrop_while @ A @ ( comp @ $o @ $o @ A @ (~) @ P ) @ S ) ) ) ).

% sfilter.simps(1)
thf(fact_149_treeFI_Octr__transfer,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o] : ( bNF_rel_fun @ A @ B @ ( ( list @ ( treeFI @ A ) ) > ( treeFI @ A ) ) @ ( ( list @ ( treeFI @ B ) ) > ( treeFI @ B ) ) @ R @ ( bNF_rel_fun @ ( list @ ( treeFI @ A ) ) @ ( list @ ( treeFI @ B ) ) @ ( treeFI @ A ) @ ( treeFI @ B ) @ ( list_all2 @ ( treeFI @ A ) @ ( treeFI @ B ) @ ( rel_treeFI @ A @ B @ R ) ) @ ( rel_treeFI @ A @ B @ R ) ) @ ( tree @ A ) @ ( tree @ B ) ) ).

% treeFI.ctr_transfer
thf(fact_150_foldl__cong,axiom,
    ! [A: $tType,B: $tType,A2: A,B2: A,L: list @ B,K: list @ B,F2: A > B > A,G: A > B > A] :
      ( ( A2 = B2 )
     => ( ( L = K )
       => ( ! [A5: A,X: B] :
              ( ( member2 @ B @ X @ ( set2 @ B @ L ) )
             => ( ( F2 @ A5 @ X )
                = ( G @ A5 @ X ) ) )
         => ( ( foldl @ A @ B @ F2 @ A2 @ L )
            = ( foldl @ A @ B @ G @ B2 @ K ) ) ) ) ) ).

% foldl_cong
thf(fact_151_product__lists__transfer,axiom,
    ! [A: $tType,B: $tType,A4: A > B > $o] : ( bNF_rel_fun @ ( list @ ( list @ A ) ) @ ( list @ ( list @ B ) ) @ ( list @ ( list @ A ) ) @ ( list @ ( list @ B ) ) @ ( list_all2 @ ( list @ A ) @ ( list @ B ) @ ( list_all2 @ A @ B @ A4 ) ) @ ( list_all2 @ ( list @ A ) @ ( list @ B ) @ ( list_all2 @ A @ B @ A4 ) ) @ ( product_lists @ A ) @ ( product_lists @ B ) ) ).

% product_lists_transfer
thf(fact_152_sfilter__Stream,axiom,
    ! [A: $tType,P: A > $o,X4: A,S: stream @ A] :
      ( ( ( P @ X4 )
       => ( ( sfilter @ A @ P @ ( sCons @ A @ X4 @ S ) )
          = ( sCons @ A @ X4 @ ( sfilter @ A @ P @ S ) ) ) )
      & ( ~ ( P @ X4 )
       => ( ( sfilter @ A @ P @ ( sCons @ A @ X4 @ S ) )
          = ( sfilter @ A @ P @ S ) ) ) ) ).

% sfilter_Stream
thf(fact_153_list_Ocase__transfer,axiom,
    ! [C: $tType,A: $tType,B: $tType,D: $tType,S5: C > D > $o,R: A > B > $o] : ( bNF_rel_fun @ C @ D @ ( ( A > ( list @ A ) > C ) > ( list @ A ) > C ) @ ( ( B > ( list @ B ) > D ) > ( list @ B ) > D ) @ S5 @ ( bNF_rel_fun @ ( A > ( list @ A ) > C ) @ ( B > ( list @ B ) > D ) @ ( ( list @ A ) > C ) @ ( ( list @ B ) > D ) @ ( bNF_rel_fun @ A @ B @ ( ( list @ A ) > C ) @ ( ( list @ B ) > D ) @ R @ ( bNF_rel_fun @ ( list @ A ) @ ( list @ B ) @ C @ D @ ( list_all2 @ A @ B @ R ) @ S5 ) ) @ ( bNF_rel_fun @ ( list @ A ) @ ( list @ B ) @ C @ D @ ( list_all2 @ A @ B @ R ) @ S5 ) ) @ ( case_list @ C @ A ) @ ( case_list @ D @ B ) ) ).

% list.case_transfer
thf(fact_154_fun_Orel__map_I2_J,axiom,
    ! [A: $tType,C: $tType,B: $tType,D: $tType,Sa: A > C > $o,X4: D > A,G: B > C,Y4: D > B] :
      ( ( bNF_rel_fun @ D @ D @ A @ C
        @ ^ [Y2: D,Z: D] : ( Y2 = Z )
        @ Sa
        @ X4
        @ ( comp @ B @ C @ D @ G @ Y4 ) )
      = ( bNF_rel_fun @ D @ D @ A @ B
        @ ^ [Y2: D,Z: D] : ( Y2 = Z )
        @ ^ [X6: A,Y: B] : ( Sa @ X6 @ ( G @ Y ) )
        @ X4
        @ Y4 ) ) ).

% fun.rel_map(2)
thf(fact_155_fun_Orel__map_I1_J,axiom,
    ! [A: $tType,C: $tType,B: $tType,D: $tType,Sb: C > B > $o,I: A > C,X4: D > A,Y4: D > B] :
      ( ( bNF_rel_fun @ D @ D @ C @ B
        @ ^ [Y2: D,Z: D] : ( Y2 = Z )
        @ Sb
        @ ( comp @ A @ C @ D @ I @ X4 )
        @ Y4 )
      = ( bNF_rel_fun @ D @ D @ A @ B
        @ ^ [Y2: D,Z: D] : ( Y2 = Z )
        @ ^ [X6: A] : ( Sb @ ( I @ X6 ) )
        @ X4
        @ Y4 ) ) ).

% fun.rel_map(1)
thf(fact_156_foldr__transfer,axiom,
    ! [A: $tType,B: $tType,D: $tType,C: $tType,A4: A > C > $o,B3: B > D > $o] : ( bNF_rel_fun @ ( A > B > B ) @ ( C > D > D ) @ ( ( list @ A ) > B > B ) @ ( ( list @ C ) > D > D ) @ ( bNF_rel_fun @ A @ C @ ( B > B ) @ ( D > D ) @ A4 @ ( bNF_rel_fun @ B @ D @ B @ D @ B3 @ B3 ) ) @ ( bNF_rel_fun @ ( list @ A ) @ ( list @ C ) @ ( B > B ) @ ( D > D ) @ ( list_all2 @ A @ C @ A4 ) @ ( bNF_rel_fun @ B @ D @ B @ D @ B3 @ B3 ) ) @ ( foldr @ A @ B ) @ ( foldr @ C @ D ) ) ).

% foldr_transfer
thf(fact_157_foldr__cong,axiom,
    ! [B: $tType,A: $tType,A2: A,B2: A,L: list @ B,K: list @ B,F2: B > A > A,G: B > A > A] :
      ( ( A2 = B2 )
     => ( ( L = K )
       => ( ! [A5: A,X: B] :
              ( ( member2 @ B @ X @ ( set2 @ B @ L ) )
             => ( ( F2 @ X @ A5 )
                = ( G @ X @ A5 ) ) )
         => ( ( foldr @ B @ A @ F2 @ L @ A2 )
            = ( foldr @ B @ A @ G @ K @ B2 ) ) ) ) ) ).

% foldr_cong
thf(fact_158_list_Ocase__distrib,axiom,
    ! [B: $tType,C: $tType,A: $tType,H: B > C,F1: B,F22: A > ( list @ A ) > B,List: list @ A] :
      ( ( H @ ( case_list @ B @ A @ F1 @ F22 @ List ) )
      = ( case_list @ C @ A @ ( H @ F1 )
        @ ^ [X13: A,X23: list @ A] : ( H @ ( F22 @ X13 @ X23 ) )
        @ List ) ) ).

% list.case_distrib
thf(fact_159_fun_Omap__ident,axiom,
    ! [A: $tType,D: $tType,T3: D > A] :
      ( ( comp @ A @ A @ D
        @ ^ [X6: A] : X6
        @ T3 )
      = T3 ) ).

% fun.map_ident
thf(fact_160_fold__transfer,axiom,
    ! [A: $tType,B: $tType,D: $tType,C: $tType,A4: A > C > $o,B3: B > D > $o] : ( bNF_rel_fun @ ( A > B > B ) @ ( C > D > D ) @ ( ( list @ A ) > B > B ) @ ( ( list @ C ) > D > D ) @ ( bNF_rel_fun @ A @ C @ ( B > B ) @ ( D > D ) @ A4 @ ( bNF_rel_fun @ B @ D @ B @ D @ B3 @ B3 ) ) @ ( bNF_rel_fun @ ( list @ A ) @ ( list @ C ) @ ( B > B ) @ ( D > D ) @ ( list_all2 @ A @ C @ A4 ) @ ( bNF_rel_fun @ B @ D @ B @ D @ B3 @ B3 ) ) @ ( fold @ A @ B ) @ ( fold @ C @ D ) ) ).

% fold_transfer
thf(fact_161_treeFI_Opred__transfer,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o] :
      ( bNF_rel_fun @ ( A > $o ) @ ( B > $o ) @ ( ( treeFI @ A ) > $o ) @ ( ( treeFI @ B ) > $o )
      @ ( bNF_rel_fun @ A @ B @ $o @ $o @ R
        @ ^ [Y2: $o,Z: $o] : ( Y2 = Z ) )
      @ ( bNF_rel_fun @ ( treeFI @ A ) @ ( treeFI @ B ) @ $o @ $o @ ( rel_treeFI @ A @ B @ R )
        @ ^ [Y2: $o,Z: $o] : ( Y2 = Z ) )
      @ ( pred_treeFI @ A )
      @ ( pred_treeFI @ B ) ) ).

% treeFI.pred_transfer
thf(fact_162_null__transfer,axiom,
    ! [A: $tType,B: $tType,A4: A > B > $o] :
      ( bNF_rel_fun @ ( list @ A ) @ ( list @ B ) @ $o @ $o @ ( list_all2 @ A @ B @ A4 )
      @ ^ [Y2: $o,Z: $o] : ( Y2 = Z )
      @ ( null @ A )
      @ ( null @ B ) ) ).

% null_transfer
thf(fact_163_fold__invariant,axiom,
    ! [A: $tType,B: $tType,Xs: list @ A,Q: A > $o,P: B > $o,S: B,F2: A > B > B] :
      ( ! [X: A] :
          ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
         => ( Q @ X ) )
     => ( ( P @ S )
       => ( ! [X: A,S6: B] :
              ( ( Q @ X )
             => ( ( P @ S6 )
               => ( P @ ( F2 @ X @ S6 ) ) ) )
         => ( P @ ( fold @ A @ B @ F2 @ Xs @ S ) ) ) ) ) ).

% fold_invariant
thf(fact_164_List_Ofold__cong,axiom,
    ! [B: $tType,A: $tType,A2: A,B2: A,Xs: list @ B,Ys: list @ B,F2: B > A > A,G: B > A > A] :
      ( ( A2 = B2 )
     => ( ( Xs = Ys )
       => ( ! [X: B] :
              ( ( member2 @ B @ X @ ( set2 @ B @ Xs ) )
             => ( ( F2 @ X )
                = ( G @ X ) ) )
         => ( ( fold @ B @ A @ F2 @ Xs @ A2 )
            = ( fold @ B @ A @ G @ Ys @ B2 ) ) ) ) ) ).

% List.fold_cong
thf(fact_165_treeFI_Opred__True,axiom,
    ! [A: $tType] :
      ( ( pred_treeFI @ A
        @ ^ [Uu: A] : $true )
      = ( ^ [Uu: treeFI @ A] : $true ) ) ).

% treeFI.pred_True
thf(fact_166_foldl__conv__fold,axiom,
    ! [B: $tType,A: $tType] :
      ( ( foldl @ A @ B )
      = ( ^ [F: A > B > A,S3: A,Xs3: list @ B] :
            ( fold @ B @ A
            @ ^ [X6: B,T4: A] : ( F @ T4 @ X6 )
            @ Xs3
            @ S3 ) ) ) ).

% foldl_conv_fold
thf(fact_167_treeFI_Opred__mono__strong,axiom,
    ! [A: $tType,P: A > $o,X4: treeFI @ A,Pa: A > $o] :
      ( ( pred_treeFI @ A @ P @ X4 )
     => ( ! [Z3: A] :
            ( ( member2 @ A @ Z3 @ ( set_treeFI @ A @ X4 ) )
           => ( ( P @ Z3 )
             => ( Pa @ Z3 ) ) )
       => ( pred_treeFI @ A @ Pa @ X4 ) ) ) ).

% treeFI.pred_mono_strong
thf(fact_168_treeFI_Opred__cong,axiom,
    ! [A: $tType,X4: treeFI @ A,Ya: treeFI @ A,P: A > $o,Pa: A > $o] :
      ( ( X4 = Ya )
     => ( ! [Z3: A] :
            ( ( member2 @ A @ Z3 @ ( set_treeFI @ A @ Ya ) )
           => ( ( P @ Z3 )
              = ( Pa @ Z3 ) ) )
       => ( ( pred_treeFI @ A @ P @ X4 )
          = ( pred_treeFI @ A @ Pa @ Ya ) ) ) ) ).

% treeFI.pred_cong
thf(fact_169_fold__commute,axiom,
    ! [A: $tType,C: $tType,B: $tType,Xs: list @ A,H: B > C,G: A > B > B,F2: A > C > C] :
      ( ! [X: A] :
          ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
         => ( ( comp @ B @ C @ B @ H @ ( G @ X ) )
            = ( comp @ C @ C @ B @ ( F2 @ X ) @ H ) ) )
     => ( ( comp @ B @ C @ B @ H @ ( fold @ A @ B @ G @ Xs ) )
        = ( comp @ C @ C @ B @ ( fold @ A @ C @ F2 @ Xs ) @ H ) ) ) ).

% fold_commute
thf(fact_170_fold__commute__apply,axiom,
    ! [A: $tType,C: $tType,B: $tType,Xs: list @ A,H: B > C,G: A > B > B,F2: A > C > C,S: B] :
      ( ! [X: A] :
          ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
         => ( ( comp @ B @ C @ B @ H @ ( G @ X ) )
            = ( comp @ C @ C @ B @ ( F2 @ X ) @ H ) ) )
     => ( ( H @ ( fold @ A @ B @ G @ Xs @ S ) )
        = ( fold @ A @ C @ F2 @ Xs @ ( H @ S ) ) ) ) ).

% fold_commute_apply
thf(fact_171_foldr__fold,axiom,
    ! [B: $tType,A: $tType,Xs: list @ A,F2: A > B > B] :
      ( ! [X: A,Y3: A] :
          ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
         => ( ( member2 @ A @ Y3 @ ( set2 @ A @ Xs ) )
           => ( ( comp @ B @ B @ B @ ( F2 @ Y3 ) @ ( F2 @ X ) )
              = ( comp @ B @ B @ B @ ( F2 @ X ) @ ( F2 @ Y3 ) ) ) ) )
     => ( ( foldr @ A @ B @ F2 @ Xs )
        = ( fold @ A @ B @ F2 @ Xs ) ) ) ).

% foldr_fold
thf(fact_172_is__empty__set,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( is_empty @ A @ ( set2 @ A @ Xs ) )
      = ( null @ A @ Xs ) ) ).

% is_empty_set
thf(fact_173_concat__transfer,axiom,
    ! [A: $tType,B: $tType,A4: A > B > $o] : ( bNF_rel_fun @ ( list @ ( list @ A ) ) @ ( list @ ( list @ B ) ) @ ( list @ A ) @ ( list @ B ) @ ( list_all2 @ ( list @ A ) @ ( list @ B ) @ ( list_all2 @ A @ B @ A4 ) ) @ ( list_all2 @ A @ B @ A4 ) @ ( concat @ A ) @ ( concat @ B ) ) ).

% concat_transfer
thf(fact_174_list__ex__transfer,axiom,
    ! [A: $tType,B: $tType,A4: A > B > $o] :
      ( bNF_rel_fun @ ( A > $o ) @ ( B > $o ) @ ( ( list @ A ) > $o ) @ ( ( list @ B ) > $o )
      @ ( bNF_rel_fun @ A @ B @ $o @ $o @ A4
        @ ^ [Y2: $o,Z: $o] : ( Y2 = Z ) )
      @ ( bNF_rel_fun @ ( list @ A ) @ ( list @ B ) @ $o @ $o @ ( list_all2 @ A @ B @ A4 )
        @ ^ [Y2: $o,Z: $o] : ( Y2 = Z ) )
      @ ( list_ex @ A )
      @ ( list_ex @ B ) ) ).

% list_ex_transfer
thf(fact_175_list__ex__cong,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A,F2: A > $o,G: A > $o] :
      ( ( Xs = Ys )
     => ( ! [X: A] :
            ( ( member2 @ A @ X @ ( set2 @ A @ Ys ) )
           => ( ( F2 @ X )
              = ( G @ X ) ) )
       => ( ( list_ex @ A @ F2 @ Xs )
          = ( list_ex @ A @ G @ Ys ) ) ) ) ).

% list_ex_cong
thf(fact_176_list__all__transfer,axiom,
    ! [A: $tType,B: $tType,A4: A > B > $o] :
      ( bNF_rel_fun @ ( A > $o ) @ ( B > $o ) @ ( ( list @ A ) > $o ) @ ( ( list @ B ) > $o )
      @ ( bNF_rel_fun @ A @ B @ $o @ $o @ A4
        @ ^ [Y2: $o,Z: $o] : ( Y2 = Z ) )
      @ ( bNF_rel_fun @ ( list @ A ) @ ( list @ B ) @ $o @ $o @ ( list_all2 @ A @ B @ A4 )
        @ ^ [Y2: $o,Z: $o] : ( Y2 = Z ) )
      @ ( list_all @ A )
      @ ( list_all @ B ) ) ).

% list_all_transfer
thf(fact_177_list_Opred__transfer,axiom,
    ! [A: $tType,B: $tType,R: A > B > $o] :
      ( bNF_rel_fun @ ( A > $o ) @ ( B > $o ) @ ( ( list @ A ) > $o ) @ ( ( list @ B ) > $o )
      @ ( bNF_rel_fun @ A @ B @ $o @ $o @ R
        @ ^ [Y2: $o,Z: $o] : ( Y2 = Z ) )
      @ ( bNF_rel_fun @ ( list @ A ) @ ( list @ B ) @ $o @ $o @ ( list_all2 @ A @ B @ R )
        @ ^ [Y2: $o,Z: $o] : ( Y2 = Z ) )
      @ ( list_all @ A )
      @ ( list_all @ B ) ) ).

% list.pred_transfer
thf(fact_178_conj__comp__iff,axiom,
    ! [B: $tType,A: $tType,P: B > $o,Q: B > $o,G: A > B] :
      ( ( comp @ B @ $o @ A
        @ ^ [X6: B] :
            ( ( P @ X6 )
            & ( Q @ X6 ) )
        @ G )
      = ( ^ [X6: A] :
            ( ( comp @ B @ $o @ A @ P @ G @ X6 )
            & ( comp @ B @ $o @ A @ Q @ G @ X6 ) ) ) ) ).

% conj_comp_iff
thf(fact_179_treeFI_Opred__inject,axiom,
    ! [A: $tType,P: A > $o,A2: A,Aa2: list @ ( treeFI @ A )] :
      ( ( pred_treeFI @ A @ P @ ( tree @ A @ A2 @ Aa2 ) )
      = ( ( P @ A2 )
        & ( list_all @ ( treeFI @ A ) @ ( pred_treeFI @ A @ P ) @ Aa2 ) ) ) ).

% treeFI.pred_inject
thf(fact_180_list_Opred__cong,axiom,
    ! [A: $tType,X4: list @ A,Ya: list @ A,P: A > $o,Pa: A > $o] :
      ( ( X4 = Ya )
     => ( ! [Z3: A] :
            ( ( member2 @ A @ Z3 @ ( set2 @ A @ Ya ) )
           => ( ( P @ Z3 )
              = ( Pa @ Z3 ) ) )
       => ( ( list_all @ A @ P @ X4 )
          = ( list_all @ A @ Pa @ Ya ) ) ) ) ).

% list.pred_cong
thf(fact_181_list_Opred__mono__strong,axiom,
    ! [A: $tType,P: A > $o,X4: list @ A,Pa: A > $o] :
      ( ( list_all @ A @ P @ X4 )
     => ( ! [Z3: A] :
            ( ( member2 @ A @ Z3 @ ( set2 @ A @ X4 ) )
           => ( ( P @ Z3 )
             => ( Pa @ Z3 ) ) )
       => ( list_all @ A @ Pa @ X4 ) ) ) ).

% list.pred_mono_strong
thf(fact_182_list_Opred__True,axiom,
    ! [A: $tType] :
      ( ( list_all @ A
        @ ^ [Uu: A] : $true )
      = ( ^ [Uu: list @ A] : $true ) ) ).

% list.pred_True
thf(fact_183_K__record__comp,axiom,
    ! [C: $tType,B: $tType,A: $tType,C3: B,F2: A > C] :
      ( ( comp @ C @ B @ A
        @ ^ [X6: C] : C3
        @ F2 )
      = ( ^ [X6: A] : C3 ) ) ).

% K_record_comp
thf(fact_184_stream__all__shift,axiom,
    ! [A: $tType,P: A > $o,Xs: list @ A,S: stream @ A] :
      ( ( stream_all @ A @ P @ ( shift @ A @ Xs @ S ) )
      = ( ( list_all @ A @ P @ Xs )
        & ( stream_all @ A @ P @ S ) ) ) ).

% stream_all_shift
thf(fact_185_splice__transfer,axiom,
    ! [A: $tType,B: $tType,A4: A > B > $o] : ( bNF_rel_fun @ ( list @ A ) @ ( list @ B ) @ ( ( list @ A ) > ( list @ A ) ) @ ( ( list @ B ) > ( list @ B ) ) @ ( list_all2 @ A @ B @ A4 ) @ ( bNF_rel_fun @ ( list @ A ) @ ( list @ B ) @ ( list @ A ) @ ( list @ B ) @ ( list_all2 @ A @ B @ A4 ) @ ( list_all2 @ A @ B @ A4 ) ) @ ( splice @ A ) @ ( splice @ B ) ) ).

% splice_transfer
thf(fact_186_shift__left__inj,axiom,
    ! [A: $tType,Xs: list @ A,S12: stream @ A,S22: stream @ A] :
      ( ( ( shift @ A @ Xs @ S12 )
        = ( shift @ A @ Xs @ S22 ) )
      = ( S12 = S22 ) ) ).

% shift_left_inj
thf(fact_187_List_Oinsert__transfer,axiom,
    ! [A: $tType,B: $tType,A4: A > B > $o] :
      ( ( bi_unique @ A @ B @ A4 )
     => ( bNF_rel_fun @ A @ B @ ( ( list @ A ) > ( list @ A ) ) @ ( ( list @ B ) > ( list @ B ) ) @ A4 @ ( bNF_rel_fun @ ( list @ A ) @ ( list @ B ) @ ( list @ A ) @ ( list @ B ) @ ( list_all2 @ A @ B @ A4 ) @ ( list_all2 @ A @ B @ A4 ) ) @ ( insert @ A ) @ ( insert @ B ) ) ) ).

% List.insert_transfer
thf(fact_188_append__transfer,axiom,
    ! [A: $tType,B: $tType,A4: A > B > $o] : ( bNF_rel_fun @ ( list @ A ) @ ( list @ B ) @ ( ( list @ A ) > ( list @ A ) ) @ ( ( list @ B ) > ( list @ B ) ) @ ( list_all2 @ A @ B @ A4 ) @ ( bNF_rel_fun @ ( list @ A ) @ ( list @ B ) @ ( list @ A ) @ ( list @ B ) @ ( list_all2 @ A @ B @ A4 ) @ ( list_all2 @ A @ B @ A4 ) ) @ ( append @ A ) @ ( append @ B ) ) ).

% append_transfer
thf(fact_189_fold__remove1__split,axiom,
    ! [B: $tType,A: $tType,Xs: list @ A,F2: A > B > B,X4: A] :
      ( ! [X: A,Y3: A] :
          ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
         => ( ( member2 @ A @ Y3 @ ( set2 @ A @ Xs ) )
           => ( ( comp @ B @ B @ B @ ( F2 @ X ) @ ( F2 @ Y3 ) )
              = ( comp @ B @ B @ B @ ( F2 @ Y3 ) @ ( F2 @ X ) ) ) ) )
     => ( ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
       => ( ( fold @ A @ B @ F2 @ Xs )
          = ( comp @ B @ B @ B @ ( fold @ A @ B @ F2 @ ( remove1 @ A @ X4 @ Xs ) ) @ ( F2 @ X4 ) ) ) ) ) ).

% fold_remove1_split
thf(fact_190_in__set__remove1,axiom,
    ! [A: $tType,A2: A,B2: A,Xs: list @ A] :
      ( ( A2 != B2 )
     => ( ( member2 @ A @ A2 @ ( set2 @ A @ ( remove1 @ A @ B2 @ Xs ) ) )
        = ( member2 @ A @ A2 @ ( set2 @ A @ Xs ) ) ) ) ).

% in_set_remove1
thf(fact_191_shift__append,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A,S: stream @ A] :
      ( ( shift @ A @ ( append @ A @ Xs @ Ys ) @ S )
      = ( shift @ A @ Xs @ ( shift @ A @ Ys @ S ) ) ) ).

% shift_append
thf(fact_192_remove1__transfer,axiom,
    ! [A: $tType,B: $tType,A4: A > B > $o] :
      ( ( bi_unique @ A @ B @ A4 )
     => ( bNF_rel_fun @ A @ B @ ( ( list @ A ) > ( list @ A ) ) @ ( ( list @ B ) > ( list @ B ) ) @ A4 @ ( bNF_rel_fun @ ( list @ A ) @ ( list @ B ) @ ( list @ A ) @ ( list @ B ) @ ( list_all2 @ A @ B @ A4 ) @ ( list_all2 @ A @ B @ A4 ) ) @ ( remove1 @ A ) @ ( remove1 @ B ) ) ) ).

% remove1_transfer
thf(fact_193_list_Obi__unique__rel,axiom,
    ! [B: $tType,A: $tType,R: A > B > $o] :
      ( ( bi_unique @ A @ B @ R )
     => ( bi_unique @ ( list @ A ) @ ( list @ B ) @ ( list_all2 @ A @ B @ R ) ) ) ).

% list.bi_unique_rel
thf(fact_194_list__all2__appendI,axiom,
    ! [A: $tType,B: $tType,P: A > B > $o,A2: list @ A,B2: list @ B,C3: list @ A,D2: list @ B] :
      ( ( list_all2 @ A @ B @ P @ A2 @ B2 )
     => ( ( list_all2 @ A @ B @ P @ C3 @ D2 )
       => ( list_all2 @ A @ B @ P @ ( append @ A @ A2 @ C3 ) @ ( append @ B @ B2 @ D2 ) ) ) ) ).

% list_all2_appendI
thf(fact_195_remove1__append,axiom,
    ! [A: $tType,X4: A,Xs: list @ A,Ys: list @ A] :
      ( ( ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
       => ( ( remove1 @ A @ X4 @ ( append @ A @ Xs @ Ys ) )
          = ( append @ A @ ( remove1 @ A @ X4 @ Xs ) @ Ys ) ) )
      & ( ~ ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
       => ( ( remove1 @ A @ X4 @ ( append @ A @ Xs @ Ys ) )
          = ( append @ A @ Xs @ ( remove1 @ A @ X4 @ Ys ) ) ) ) ) ).

% remove1_append
thf(fact_196_remove1__idem,axiom,
    ! [A: $tType,X4: A,Xs: list @ A] :
      ( ~ ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
     => ( ( remove1 @ A @ X4 @ Xs )
        = Xs ) ) ).

% remove1_idem
thf(fact_197_notin__set__remove1,axiom,
    ! [A: $tType,X4: A,Xs: list @ A,Y4: A] :
      ( ~ ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
     => ~ ( member2 @ A @ X4 @ ( set2 @ A @ ( remove1 @ A @ Y4 @ Xs ) ) ) ) ).

% notin_set_remove1
thf(fact_198_treeFI_Obi__unique__rel,axiom,
    ! [B: $tType,A: $tType,R: A > B > $o] :
      ( ( bi_unique @ A @ B @ R )
     => ( bi_unique @ ( treeFI @ A ) @ ( treeFI @ B ) @ ( rel_treeFI @ A @ B @ R ) ) ) ).

% treeFI.bi_unique_rel
thf(fact_199_removeAll__transfer,axiom,
    ! [A: $tType,B: $tType,A4: A > B > $o] :
      ( ( bi_unique @ A @ B @ A4 )
     => ( bNF_rel_fun @ A @ B @ ( ( list @ A ) > ( list @ A ) ) @ ( ( list @ B ) > ( list @ B ) ) @ A4 @ ( bNF_rel_fun @ ( list @ A ) @ ( list @ B ) @ ( list @ A ) @ ( list @ B ) @ ( list_all2 @ A @ B @ A4 ) @ ( list_all2 @ A @ B @ A4 ) ) @ ( removeAll @ A ) @ ( removeAll @ B ) ) ) ).

% removeAll_transfer
thf(fact_200_remdups__transfer,axiom,
    ! [A: $tType,B: $tType,A4: A > B > $o] :
      ( ( bi_unique @ A @ B @ A4 )
     => ( bNF_rel_fun @ ( list @ A ) @ ( list @ B ) @ ( list @ A ) @ ( list @ B ) @ ( list_all2 @ A @ B @ A4 ) @ ( list_all2 @ A @ B @ A4 ) @ ( remdups @ A ) @ ( remdups @ B ) ) ) ).

% remdups_transfer
thf(fact_201_set__remdups,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( set2 @ A @ ( remdups @ A @ Xs ) )
      = ( set2 @ A @ Xs ) ) ).

% set_remdups
thf(fact_202_removeAll__id,axiom,
    ! [A: $tType,X4: A,Xs: list @ A] :
      ( ~ ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
     => ( ( removeAll @ A @ X4 @ Xs )
        = Xs ) ) ).

% removeAll_id
thf(fact_203_remove__code_I1_J,axiom,
    ! [A: $tType,X4: A,Xs: list @ A] :
      ( ( remove @ A @ X4 @ ( set2 @ A @ Xs ) )
      = ( set2 @ A @ ( removeAll @ A @ X4 @ Xs ) ) ) ).

% remove_code(1)
thf(fact_204_remdups__adj__transfer,axiom,
    ! [A: $tType,B: $tType,A4: A > B > $o] :
      ( ( bi_unique @ A @ B @ A4 )
     => ( bNF_rel_fun @ ( list @ A ) @ ( list @ B ) @ ( list @ A ) @ ( list @ B ) @ ( list_all2 @ A @ B @ A4 ) @ ( list_all2 @ A @ B @ A4 ) @ ( remdups_adj @ A ) @ ( remdups_adj @ B ) ) ) ).

% remdups_adj_transfer
thf(fact_205_remdups__adj__set,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( set2 @ A @ ( remdups_adj @ A @ Xs ) )
      = ( set2 @ A @ Xs ) ) ).

% remdups_adj_set
thf(fact_206_fun_Opred__map,axiom,
    ! [B: $tType,A: $tType,D: $tType,Q: B > $o,F2: A > B,X4: D > A] :
      ( ( basic_pred_fun @ D @ B
        @ ^ [Uu: D] : $true
        @ Q
        @ ( comp @ A @ B @ D @ F2 @ X4 ) )
      = ( basic_pred_fun @ D @ A
        @ ^ [Uu: D] : $true
        @ ( comp @ B @ $o @ A @ Q @ F2 )
        @ X4 ) ) ).

% fun.pred_map
thf(fact_207_rotate1__transfer,axiom,
    ! [A: $tType,B: $tType,A4: A > B > $o] : ( bNF_rel_fun @ ( list @ A ) @ ( list @ B ) @ ( list @ A ) @ ( list @ B ) @ ( list_all2 @ A @ B @ A4 ) @ ( list_all2 @ A @ B @ A4 ) @ ( rotate1 @ A ) @ ( rotate1 @ B ) ) ).

% rotate1_transfer
thf(fact_208_set__rotate1,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( set2 @ A @ ( rotate1 @ A @ Xs ) )
      = ( set2 @ A @ Xs ) ) ).

% set_rotate1
thf(fact_209_fun_Omap__cong__pred,axiom,
    ! [B: $tType,A: $tType,D: $tType,X4: D > A,Ya: D > A,F2: A > B,G: A > B] :
      ( ( X4 = Ya )
     => ( ( basic_pred_fun @ D @ A
          @ ^ [Uu: D] : $true
          @ ^ [Z4: A] :
              ( ( F2 @ Z4 )
              = ( G @ Z4 ) )
          @ Ya )
       => ( ( comp @ A @ B @ D @ F2 @ X4 )
          = ( comp @ A @ B @ D @ G @ Ya ) ) ) ) ).

% fun.map_cong_pred
thf(fact_210_fun_Opred__True,axiom,
    ! [A: $tType,D: $tType] :
      ( ( basic_pred_fun @ D @ A
        @ ^ [Uu: D] : $true
        @ ^ [Uu: A] : $true )
      = ( ^ [Uu: D > A] : $true ) ) ).

% fun.pred_True
thf(fact_211_fun_Opred__transfer,axiom,
    ! [A: $tType,B: $tType,D: $tType,R: A > B > $o] :
      ( bNF_rel_fun @ ( A > $o ) @ ( B > $o ) @ ( ( D > A ) > $o ) @ ( ( D > B ) > $o )
      @ ( bNF_rel_fun @ A @ B @ $o @ $o @ R
        @ ^ [Y2: $o,Z: $o] : ( Y2 = Z ) )
      @ ( bNF_rel_fun @ ( D > A ) @ ( D > B ) @ $o @ $o
        @ ( bNF_rel_fun @ D @ D @ A @ B
          @ ^ [Y2: D,Z: D] : ( Y2 = Z )
          @ R )
        @ ^ [Y2: $o,Z: $o] : ( Y2 = Z ) )
      @ ( basic_pred_fun @ D @ A
        @ ^ [Uu: D] : $true )
      @ ( basic_pred_fun @ D @ B
        @ ^ [Uu: D] : $true ) ) ).

% fun.pred_transfer
thf(fact_212_dropWhile__transfer,axiom,
    ! [A: $tType,B: $tType,A4: A > B > $o] :
      ( bNF_rel_fun @ ( A > $o ) @ ( B > $o ) @ ( ( list @ A ) > ( list @ A ) ) @ ( ( list @ B ) > ( list @ B ) )
      @ ( bNF_rel_fun @ A @ B @ $o @ $o @ A4
        @ ^ [Y2: $o,Z: $o] : ( Y2 = Z ) )
      @ ( bNF_rel_fun @ ( list @ A ) @ ( list @ B ) @ ( list @ A ) @ ( list @ B ) @ ( list_all2 @ A @ B @ A4 ) @ ( list_all2 @ A @ B @ A4 ) )
      @ ( dropWhile @ A )
      @ ( dropWhile @ B ) ) ).

% dropWhile_transfer
thf(fact_213_stream_Omap__o__corec,axiom,
    ! [A: $tType,B: $tType,C: $tType,F2: A > B,G: C > A,Ga: C > $o,Gb: C > ( stream @ A ),Gc: C > C] :
      ( ( comp @ ( stream @ A ) @ ( stream @ B ) @ C @ ( smap @ A @ B @ F2 ) @ ( corec_stream @ C @ A @ G @ Ga @ Gb @ Gc ) )
      = ( corec_stream @ C @ B @ ( comp @ A @ B @ C @ F2 @ G ) @ Ga @ ( comp @ ( stream @ A ) @ ( stream @ B ) @ C @ ( smap @ A @ B @ F2 ) @ Gb ) @ Gc ) ) ).

% stream.map_o_corec
thf(fact_214_dropWhile__append1,axiom,
    ! [A: $tType,X4: A,Xs: list @ A,P: A > $o,Ys: list @ A] :
      ( ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
     => ( ~ ( P @ X4 )
       => ( ( dropWhile @ A @ P @ ( append @ A @ Xs @ Ys ) )
          = ( append @ A @ ( dropWhile @ A @ P @ Xs ) @ Ys ) ) ) ) ).

% dropWhile_append1
thf(fact_215_dropWhile__append2,axiom,
    ! [A: $tType,Xs: list @ A,P: A > $o,Ys: list @ A] :
      ( ! [X: A] :
          ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
         => ( P @ X ) )
     => ( ( dropWhile @ A @ P @ ( append @ A @ Xs @ Ys ) )
        = ( dropWhile @ A @ P @ Ys ) ) ) ).

% dropWhile_append2
thf(fact_216_stream_Ocorec__sel_I2_J,axiom,
    ! [A: $tType,C: $tType,Q2: C > $o,A2: C,G1: C > A,G21: C > ( stream @ A ),G22: C > C] :
      ( ( ( Q2 @ A2 )
       => ( ( stl @ A @ ( corec_stream @ C @ A @ G1 @ Q2 @ G21 @ G22 @ A2 ) )
          = ( G21 @ A2 ) ) )
      & ( ~ ( Q2 @ A2 )
       => ( ( stl @ A @ ( corec_stream @ C @ A @ G1 @ Q2 @ G21 @ G22 @ A2 ) )
          = ( corec_stream @ C @ A @ G1 @ Q2 @ G21 @ G22 @ ( G22 @ A2 ) ) ) ) ) ).

% stream.corec_sel(2)
thf(fact_217_stream_Ocorec__sel_I1_J,axiom,
    ! [A: $tType,C: $tType,G1: C > A,Q2: C > $o,G21: C > ( stream @ A ),G22: C > C,A2: C] :
      ( ( shd @ A @ ( corec_stream @ C @ A @ G1 @ Q2 @ G21 @ G22 @ A2 ) )
      = ( G1 @ A2 ) ) ).

% stream.corec_sel(1)
thf(fact_218_stream_Ocorec__code,axiom,
    ! [A: $tType,C: $tType] :
      ( ( corec_stream @ C @ A )
      = ( ^ [G12: C > A,Q22: C > $o,G212: C > ( stream @ A ),G222: C > C,A3: C] : ( sCons @ A @ ( G12 @ A3 ) @ ( if @ ( stream @ A ) @ ( Q22 @ A3 ) @ ( G212 @ A3 ) @ ( corec_stream @ C @ A @ G12 @ Q22 @ G212 @ G222 @ ( G222 @ A3 ) ) ) ) ) ) ).

% stream.corec_code
thf(fact_219_dropWhile__cong,axiom,
    ! [A: $tType,L: list @ A,K: list @ A,P: A > $o,Q: A > $o] :
      ( ( L = K )
     => ( ! [X: A] :
            ( ( member2 @ A @ X @ ( set2 @ A @ L ) )
           => ( ( P @ X )
              = ( Q @ X ) ) )
       => ( ( dropWhile @ A @ P @ L )
          = ( dropWhile @ A @ Q @ K ) ) ) ) ).

% dropWhile_cong
thf(fact_220_set__dropWhileD,axiom,
    ! [A: $tType,X4: A,P: A > $o,Xs: list @ A] :
      ( ( member2 @ A @ X4 @ ( set2 @ A @ ( dropWhile @ A @ P @ Xs ) ) )
     => ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) ) ) ).

% set_dropWhileD
thf(fact_221_stream_Ocorec__disc,axiom,
    ! [A: $tType,C: $tType] :
      ( ( corec_stream @ C @ A )
      = ( corec_stream @ C @ A ) ) ).

% stream.corec_disc
thf(fact_222_takeWhile__transfer,axiom,
    ! [A: $tType,B: $tType,A4: A > B > $o] :
      ( bNF_rel_fun @ ( A > $o ) @ ( B > $o ) @ ( ( list @ A ) > ( list @ A ) ) @ ( ( list @ B ) > ( list @ B ) )
      @ ( bNF_rel_fun @ A @ B @ $o @ $o @ A4
        @ ^ [Y2: $o,Z: $o] : ( Y2 = Z ) )
      @ ( bNF_rel_fun @ ( list @ A ) @ ( list @ B ) @ ( list @ A ) @ ( list @ B ) @ ( list_all2 @ A @ B @ A4 ) @ ( list_all2 @ A @ B @ A4 ) )
      @ ( takeWhile @ A )
      @ ( takeWhile @ B ) ) ).

% takeWhile_transfer
thf(fact_223_List_Ofilter__transfer,axiom,
    ! [A: $tType,B: $tType,A4: A > B > $o] :
      ( bNF_rel_fun @ ( A > $o ) @ ( B > $o ) @ ( ( list @ A ) > ( list @ A ) ) @ ( ( list @ B ) > ( list @ B ) )
      @ ( bNF_rel_fun @ A @ B @ $o @ $o @ A4
        @ ^ [Y2: $o,Z: $o] : ( Y2 = Z ) )
      @ ( bNF_rel_fun @ ( list @ A ) @ ( list @ B ) @ ( list @ A ) @ ( list @ B ) @ ( list_all2 @ A @ B @ A4 ) @ ( list_all2 @ A @ B @ A4 ) )
      @ ( filter @ A )
      @ ( filter @ B ) ) ).

% List.filter_transfer
thf(fact_224_filter__filter,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o,Xs: list @ A] :
      ( ( filter @ A @ P @ ( filter @ A @ Q @ Xs ) )
      = ( filter @ A
        @ ^ [X6: A] :
            ( ( Q @ X6 )
            & ( P @ X6 ) )
        @ Xs ) ) ).

% filter_filter
thf(fact_225_filter__True,axiom,
    ! [A: $tType,Xs: list @ A,P: A > $o] :
      ( ! [X: A] :
          ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
         => ( P @ X ) )
     => ( ( filter @ A @ P @ Xs )
        = Xs ) ) ).

% filter_True
thf(fact_226_takeWhile__eq__all__conv,axiom,
    ! [A: $tType,P: A > $o,Xs: list @ A] :
      ( ( ( takeWhile @ A @ P @ Xs )
        = Xs )
      = ( ! [X6: A] :
            ( ( member2 @ A @ X6 @ ( set2 @ A @ Xs ) )
           => ( P @ X6 ) ) ) ) ).

% takeWhile_eq_all_conv
thf(fact_227_set__filter,axiom,
    ! [A: $tType,P: A > $o,Xs: list @ A] :
      ( ( set2 @ A @ ( filter @ A @ P @ Xs ) )
      = ( collect @ A
        @ ^ [X6: A] :
            ( ( member2 @ A @ X6 @ ( set2 @ A @ Xs ) )
            & ( P @ X6 ) ) ) ) ).

% set_filter
thf(fact_228_takeWhile__append2,axiom,
    ! [A: $tType,Xs: list @ A,P: A > $o,Ys: list @ A] :
      ( ! [X: A] :
          ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
         => ( P @ X ) )
     => ( ( takeWhile @ A @ P @ ( append @ A @ Xs @ Ys ) )
        = ( append @ A @ Xs @ ( takeWhile @ A @ P @ Ys ) ) ) ) ).

% takeWhile_append2
thf(fact_229_takeWhile__append1,axiom,
    ! [A: $tType,X4: A,Xs: list @ A,P: A > $o,Ys: list @ A] :
      ( ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
     => ( ~ ( P @ X4 )
       => ( ( takeWhile @ A @ P @ ( append @ A @ Xs @ Ys ) )
          = ( takeWhile @ A @ P @ Xs ) ) ) ) ).

% takeWhile_append1
thf(fact_230_takeWhile__eq__filter,axiom,
    ! [A: $tType,P: A > $o,Xs: list @ A] :
      ( ! [X: A] :
          ( ( member2 @ A @ X @ ( set2 @ A @ ( dropWhile @ A @ P @ Xs ) ) )
         => ~ ( P @ X ) )
     => ( ( takeWhile @ A @ P @ Xs )
        = ( filter @ A @ P @ Xs ) ) ) ).

% takeWhile_eq_filter
thf(fact_231_filter__cong,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A,P: A > $o,Q: A > $o] :
      ( ( Xs = Ys )
     => ( ! [X: A] :
            ( ( member2 @ A @ X @ ( set2 @ A @ Ys ) )
           => ( ( P @ X )
              = ( Q @ X ) ) )
       => ( ( filter @ A @ P @ Xs )
          = ( filter @ A @ Q @ Ys ) ) ) ) ).

% filter_cong
thf(fact_232_filter__id__conv,axiom,
    ! [A: $tType,P: A > $o,Xs: list @ A] :
      ( ( ( filter @ A @ P @ Xs )
        = Xs )
      = ( ! [X6: A] :
            ( ( member2 @ A @ X6 @ ( set2 @ A @ Xs ) )
           => ( P @ X6 ) ) ) ) ).

% filter_id_conv
thf(fact_233_set__takeWhileD,axiom,
    ! [A: $tType,X4: A,P: A > $o,Xs: list @ A] :
      ( ( member2 @ A @ X4 @ ( set2 @ A @ ( takeWhile @ A @ P @ Xs ) ) )
     => ( ( member2 @ A @ X4 @ ( set2 @ A @ Xs ) )
        & ( P @ X4 ) ) ) ).

% set_takeWhileD
thf(fact_234_takeWhile__cong,axiom,
    ! [A: $tType,L: list @ A,K: list @ A,P: A > $o,Q: A > $o] :
      ( ( L = K )
     => ( ! [X: A] :
            ( ( member2 @ A @ X @ ( set2 @ A @ L ) )
           => ( ( P @ X )
              = ( Q @ X ) ) )
       => ( ( takeWhile @ A @ P @ L )
          = ( takeWhile @ A @ Q @ K ) ) ) ) ).

% takeWhile_cong
thf(fact_235_removeAll__filter__not__eq,axiom,
    ! [A: $tType] :
      ( ( removeAll @ A )
      = ( ^ [X6: A] :
            ( filter @ A
            @ ^ [Y: A] : ( X6 != Y ) ) ) ) ).

% removeAll_filter_not_eq
thf(fact_236_list_Omap__transfer,axiom,
    ! [A: $tType,B: $tType,F3: $tType,E2: $tType,Rb: A > E2 > $o,Sd: B > F3 > $o] : ( bNF_rel_fun @ ( A > B ) @ ( E2 > F3 ) @ ( ( list @ A ) > ( list @ B ) ) @ ( ( list @ E2 ) > ( list @ F3 ) ) @ ( bNF_rel_fun @ A @ E2 @ B @ F3 @ Rb @ Sd ) @ ( bNF_rel_fun @ ( list @ A ) @ ( list @ E2 ) @ ( list @ B ) @ ( list @ F3 ) @ ( list_all2 @ A @ E2 @ Rb ) @ ( list_all2 @ B @ F3 @ Sd ) ) @ ( map @ A @ B ) @ ( map @ E2 @ F3 ) ) ).

% list.map_transfer
thf(fact_237_filter__set,axiom,
    ! [A: $tType,P: A > $o,Xs: list @ A] :
      ( ( filter2 @ A @ P @ ( set2 @ A @ Xs ) )
      = ( set2 @ A @ ( filter @ A @ P @ Xs ) ) ) ).

% filter_set
thf(fact_238_map__ident,axiom,
    ! [A: $tType] :
      ( ( map @ A @ A
        @ ^ [X6: A] : X6 )
      = ( ^ [Xs3: list @ A] : Xs3 ) ) ).

% map_ident
thf(fact_239_map__eq__conv,axiom,
    ! [A: $tType,B: $tType,F2: B > A,Xs: list @ B,G: B > A] :
      ( ( ( map @ B @ A @ F2 @ Xs )
        = ( map @ B @ A @ G @ Xs ) )
      = ( ! [X6: B] :
            ( ( member2 @ B @ X6 @ ( set2 @ B @ Xs ) )
           => ( ( F2 @ X6 )
              = ( G @ X6 ) ) ) ) ) ).

% map_eq_conv
thf(fact_240_smap__shift,axiom,
    ! [A: $tType,B: $tType,F2: B > A,Xs: list @ B,S: stream @ B] :
      ( ( smap @ B @ A @ F2 @ ( shift @ B @ Xs @ S ) )
      = ( shift @ A @ ( map @ B @ A @ F2 @ Xs ) @ ( smap @ B @ A @ F2 @ S ) ) ) ).

% smap_shift
thf(fact_241_list_Omap__cong__pred,axiom,
    ! [B: $tType,A: $tType,X4: list @ A,Ya: list @ A,F2: A > B,G: A > B] :
      ( ( X4 = Ya )
     => ( ( list_all @ A
          @ ^ [Z4: A] :
              ( ( F2 @ Z4 )
              = ( G @ Z4 ) )
          @ Ya )
       => ( ( map @ A @ B @ F2 @ X4 )
          = ( map @ A @ B @ G @ Ya ) ) ) ) ).

% list.map_cong_pred
thf(fact_242_list_Orel__map_I2_J,axiom,
    ! [A: $tType,C: $tType,B: $tType,Sa: A > C > $o,X4: list @ A,G: B > C,Y4: list @ B] :
      ( ( list_all2 @ A @ C @ Sa @ X4 @ ( map @ B @ C @ G @ Y4 ) )
      = ( list_all2 @ A @ B
        @ ^ [X6: A,Y: B] : ( Sa @ X6 @ ( G @ Y ) )
        @ X4
        @ Y4 ) ) ).

% list.rel_map(2)
thf(fact_243_list_Orel__map_I1_J,axiom,
    ! [A: $tType,C: $tType,B: $tType,Sb: C > B > $o,I: A > C,X4: list @ A,Y4: list @ B] :
      ( ( list_all2 @ C @ B @ Sb @ ( map @ A @ C @ I @ X4 ) @ Y4 )
      = ( list_all2 @ A @ B
        @ ^ [X6: A] : ( Sb @ ( I @ X6 ) )
        @ X4
        @ Y4 ) ) ).

% list.rel_map(1)
thf(fact_244_list__all2__map1,axiom,
    ! [C: $tType,A: $tType,B: $tType,P: A > B > $o,F2: C > A,As: list @ C,Bs: list @ B] :
      ( ( list_all2 @ A @ B @ P @ ( map @ C @ A @ F2 @ As ) @ Bs )
      = ( list_all2 @ C @ B
        @ ^ [X6: C] : ( P @ ( F2 @ X6 ) )
        @ As
        @ Bs ) ) ).

% list_all2_map1
thf(fact_245_list__all2__map2,axiom,
    ! [A: $tType,B: $tType,C: $tType,P: A > B > $o,As: list @ A,F2: C > B,Bs: list @ C] :
      ( ( list_all2 @ A @ B @ P @ As @ ( map @ C @ B @ F2 @ Bs ) )
      = ( list_all2 @ A @ C
        @ ^ [X6: A,Y: C] : ( P @ X6 @ ( F2 @ Y ) )
        @ As
        @ Bs ) ) ).

% list_all2_map2
thf(fact_246_foldl__map,axiom,
    ! [A: $tType,B: $tType,C: $tType,G: A > B > A,A2: A,F2: C > B,Xs: list @ C] :
      ( ( foldl @ A @ B @ G @ A2 @ ( map @ C @ B @ F2 @ Xs ) )
      = ( foldl @ A @ C
        @ ^ [A3: A,X6: C] : ( G @ A3 @ ( F2 @ X6 ) )
        @ A2
        @ Xs ) ) ).

% foldl_map
thf(fact_247_list_Oinj__map__strong,axiom,
    ! [B: $tType,A: $tType,X4: list @ A,Xa: list @ A,F2: A > B,Fa: A > B] :
      ( ! [Z3: A,Za: A] :
          ( ( member2 @ A @ Z3 @ ( set2 @ A @ X4 ) )
         => ( ( member2 @ A @ Za @ ( set2 @ A @ Xa ) )
           => ( ( ( F2 @ Z3 )
                = ( Fa @ Za ) )
             => ( Z3 = Za ) ) ) )
     => ( ( ( map @ A @ B @ F2 @ X4 )
          = ( map @ A @ B @ Fa @ Xa ) )
       => ( X4 = Xa ) ) ) ).

% list.inj_map_strong
thf(fact_248_list_Omap__cong0,axiom,
    ! [B: $tType,A: $tType,X4: list @ A,F2: A > B,G: A > B] :
      ( ! [Z3: A] :
          ( ( member2 @ A @ Z3 @ ( set2 @ A @ X4 ) )
         => ( ( F2 @ Z3 )
            = ( G @ Z3 ) ) )
     => ( ( map @ A @ B @ F2 @ X4 )
        = ( map @ A @ B @ G @ X4 ) ) ) ).

% list.map_cong0
thf(fact_249_list_Omap__cong,axiom,
    ! [B: $tType,A: $tType,X4: list @ A,Ya: list @ A,F2: A > B,G: A > B] :
      ( ( X4 = Ya )
     => ( ! [Z3: A] :
            ( ( member2 @ A @ Z3 @ ( set2 @ A @ Ya ) )
           => ( ( F2 @ Z3 )
              = ( G @ Z3 ) ) )
       => ( ( map @ A @ B @ F2 @ X4 )
          = ( map @ A @ B @ G @ Ya ) ) ) ) ).

% list.map_cong
thf(fact_250_ex__map__conv,axiom,
    ! [A: $tType,B: $tType,Ys: list @ B,F2: A > B] :
      ( ( ? [Xs3: list @ A] :
            ( Ys
            = ( map @ A @ B @ F2 @ Xs3 ) ) )
      = ( ! [X6: B] :
            ( ( member2 @ B @ X6 @ ( set2 @ B @ Ys ) )
           => ? [Y: A] :
                ( X6
                = ( F2 @ Y ) ) ) ) ) ).

% ex_map_conv
thf(fact_251_map__cong,axiom,
    ! [B: $tType,A: $tType,Xs: list @ A,Ys: list @ A,F2: A > B,G: A > B] :
      ( ( Xs = Ys )
     => ( ! [X: A] :
            ( ( member2 @ A @ X @ ( set2 @ A @ Ys ) )
           => ( ( F2 @ X )
              = ( G @ X ) ) )
       => ( ( map @ A @ B @ F2 @ Xs )
          = ( map @ A @ B @ G @ Ys ) ) ) ) ).

% map_cong
thf(fact_252_map__idI,axiom,
    ! [A: $tType,Xs: list @ A,F2: A > A] :
      ( ! [X: A] :
          ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
         => ( ( F2 @ X )
            = X ) )
     => ( ( map @ A @ A @ F2 @ Xs )
        = Xs ) ) ).

% map_idI
thf(fact_253_map__ext,axiom,
    ! [B: $tType,A: $tType,Xs: list @ A,F2: A > B,G: A > B] :
      ( ! [X: A] :
          ( ( member2 @ A @ X @ ( set2 @ A @ Xs ) )
         => ( ( F2 @ X )
            = ( G @ X ) ) )
     => ( ( map @ A @ B @ F2 @ Xs )
        = ( map @ A @ B @ G @ Xs ) ) ) ).

% map_ext
thf(fact_254_list_Omap__ident,axiom,
    ! [A: $tType,T3: list @ A] :
      ( ( map @ A @ A
        @ ^ [X6: A] : X6
        @ T3 )
      = T3 ) ).

% list.map_ident
thf(fact_255_list_Orec__o__map,axiom,
    ! [C: $tType,B: $tType,A: $tType,G: C,Ga: B > ( list @ B ) > C > C,F2: A > B] :
      ( ( comp @ ( list @ B ) @ C @ ( list @ A ) @ ( rec_list @ C @ B @ G @ Ga ) @ ( map @ A @ B @ F2 ) )
      = ( rec_list @ C @ A @ G
        @ ^ [X6: A,Xa3: list @ A] : ( Ga @ ( F2 @ X6 ) @ ( map @ A @ B @ F2 @ Xa3 ) ) ) ) ).

% list.rec_o_map

%----Helper facts (3)
thf(help_If_3_1_T,axiom,
    ! [P: $o] :
      ( ( P = $true )
      | ( P = $false ) ) ).

thf(help_If_2_1_T,axiom,
    ! [A: $tType,X4: A,Y4: A] :
      ( ( if @ A @ $false @ X4 @ Y4 )
      = Y4 ) ).

thf(help_If_1_1_T,axiom,
    ! [A: $tType,X4: A,Y4: A] :
      ( ( if @ A @ $true @ X4 @ Y4 )
      = X4 ) ).

%----Conjectures (1)
thf(conj_0,conjecture,
    ( ( stl @ a @ ( koenig1103336060igPath @ a @ tra ) )
    = ( koenig1103336060igPath @ a
      @ @+[T2: treeFI @ a] :
          ( ( member2 @ ( treeFI @ a ) @ T2 @ ( set2 @ ( treeFI @ a ) @ ( sub @ a @ tra ) ) )
          & ( koenig488553731niteTr @ a @ T2 ) ) ) ) ).

%------------------------------------------------------------------------------
